/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.MainThread;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzbe;
import com.google.android.gms.measurement.internal.zzft;

class zzbd
extends BroadcastReceiver {
    @VisibleForTesting
    private static final String zzks = zzbd.class.getName();
    private final zzft zzkt;
    private boolean zzku;
    private boolean zzkv;

    zzbd(zzft zzft2) {
        Preconditions.checkNotNull((Object)zzft2);
        this.zzkt = zzft2;
    }

    @MainThread
    public void onReceive(Context context, Intent intent) {
        this.zzkt.zzfy();
        String string = intent.getAction();
        this.zzkt.zzad().zzdi().zza("NetworkBroadcastReceiver received action", (Object)string);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(string)) {
            boolean bl = this.zzkt.zzfu().zzdl();
            if (this.zzkv != bl) {
                this.zzkv = bl;
                this.zzkt.zzac().zza((Runnable)new zzbe(this, bl));
            }
            return;
        }
        this.zzkt.zzad().zzdd().zza("NetworkBroadcastReceiver received unknown action", (Object)string);
    }

    @WorkerThread
    public final void zzdq() {
        this.zzkt.zzfy();
        this.zzkt.zzac().zzq();
        if (this.zzku) {
            return;
        }
        Context context = this.zzkt.getContext();
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)this, intentFilter);
        this.zzkv = this.zzkt.zzfu().zzdl();
        this.zzkt.zzad().zzdi().zza("Registering connectivity change receiver. Network connected", (Object)this.zzkv);
        this.zzku = true;
    }

    @WorkerThread
    public final void unregister() {
        this.zzkt.zzfy();
        this.zzkt.zzac().zzq();
        zzbd zzbd2 = this;
        zzbd2.zzkt.zzac().zzq();
        if (!zzbd2.zzku) {
            return;
        }
        this.zzkt.zzad().zzdi().zzaq("Unregistering connectivity change receiver");
        this.zzku = false;
        this.zzkv = false;
        Context context = this.zzkt.getContext();
        try {
            context.unregisterReceiver((BroadcastReceiver)this);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.zzkt.zzad().zzda().zza("Failed to unregister the network broadcast receiver", (Object)illegalArgumentException);
            return;
        }
    }

    static /* synthetic */ zzft zza(zzbd zzbd2) {
        return zzbd2.zzkt;
    }
}

