/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.os.Parcelable;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Pair;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzbt;
import com.google.android.gms.internal.measurement.zzbx;
import com.google.android.gms.internal.measurement.zzby;
import com.google.android.gms.internal.measurement.zzcb;
import com.google.android.gms.internal.measurement.zzcf;
import com.google.android.gms.internal.measurement.zzch;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzip;
import com.google.android.gms.internal.measurement.zziv;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgc;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzr;
import com.google.android.gms.measurement.internal.zzt;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzz;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

final class zzw
extends zzfs {
    private static final String[] zzed = new String[]{"last_bundled_timestamp", "ALTER TABLE events ADD COLUMN last_bundled_timestamp INTEGER;", "last_bundled_day", "ALTER TABLE events ADD COLUMN last_bundled_day INTEGER;", "last_sampled_complex_event_id", "ALTER TABLE events ADD COLUMN last_sampled_complex_event_id INTEGER;", "last_sampling_rate", "ALTER TABLE events ADD COLUMN last_sampling_rate INTEGER;", "last_exempt_from_sampling", "ALTER TABLE events ADD COLUMN last_exempt_from_sampling INTEGER;"};
    private static final String[] zzee = new String[]{"origin", "ALTER TABLE user_attributes ADD COLUMN origin TEXT;"};
    private static final String[] zzef = new String[]{"app_version", "ALTER TABLE apps ADD COLUMN app_version TEXT;", "app_store", "ALTER TABLE apps ADD COLUMN app_store TEXT;", "gmp_version", "ALTER TABLE apps ADD COLUMN gmp_version INTEGER;", "dev_cert_hash", "ALTER TABLE apps ADD COLUMN dev_cert_hash INTEGER;", "measurement_enabled", "ALTER TABLE apps ADD COLUMN measurement_enabled INTEGER;", "last_bundle_start_timestamp", "ALTER TABLE apps ADD COLUMN last_bundle_start_timestamp INTEGER;", "day", "ALTER TABLE apps ADD COLUMN day INTEGER;", "daily_public_events_count", "ALTER TABLE apps ADD COLUMN daily_public_events_count INTEGER;", "daily_events_count", "ALTER TABLE apps ADD COLUMN daily_events_count INTEGER;", "daily_conversions_count", "ALTER TABLE apps ADD COLUMN daily_conversions_count INTEGER;", "remote_config", "ALTER TABLE apps ADD COLUMN remote_config BLOB;", "config_fetched_time", "ALTER TABLE apps ADD COLUMN config_fetched_time INTEGER;", "failed_config_fetch_time", "ALTER TABLE apps ADD COLUMN failed_config_fetch_time INTEGER;", "app_version_int", "ALTER TABLE apps ADD COLUMN app_version_int INTEGER;", "firebase_instance_id", "ALTER TABLE apps ADD COLUMN firebase_instance_id TEXT;", "daily_error_events_count", "ALTER TABLE apps ADD COLUMN daily_error_events_count INTEGER;", "daily_realtime_events_count", "ALTER TABLE apps ADD COLUMN daily_realtime_events_count INTEGER;", "health_monitor_sample", "ALTER TABLE apps ADD COLUMN health_monitor_sample TEXT;", "android_id", "ALTER TABLE apps ADD COLUMN android_id INTEGER;", "adid_reporting_enabled", "ALTER TABLE apps ADD COLUMN adid_reporting_enabled INTEGER;", "ssaid_reporting_enabled", "ALTER TABLE apps ADD COLUMN ssaid_reporting_enabled INTEGER;", "admob_app_id", "ALTER TABLE apps ADD COLUMN admob_app_id TEXT;", "linked_admob_app_id", "ALTER TABLE apps ADD COLUMN linked_admob_app_id TEXT;", "dynamite_version", "ALTER TABLE apps ADD COLUMN dynamite_version INTEGER;"};
    private static final String[] zzeg = new String[]{"realtime", "ALTER TABLE raw_events ADD COLUMN realtime INTEGER;"};
    private static final String[] zzeh = new String[]{"has_realtime", "ALTER TABLE queue ADD COLUMN has_realtime INTEGER;", "retry_count", "ALTER TABLE queue ADD COLUMN retry_count INTEGER;"};
    private static final String[] zzei = new String[]{"previous_install_count", "ALTER TABLE app2 ADD COLUMN previous_install_count INTEGER;"};
    private final zzz zzej;
    private final zzfo zzek = new zzfo(this.zzz());

    zzw(zzft zzft2) {
        super(zzft2);
        String string = "google_app_measurement.db";
        this.zzej = new zzz(this, this.getContext(), string);
    }

    @Override
    protected final boolean zzak() {
        return false;
    }

    @WorkerThread
    public final void beginTransaction() {
        this.zzah();
        this.getWritableDatabase().beginTransaction();
    }

    @WorkerThread
    public final void setTransactionSuccessful() {
        this.zzah();
        this.getWritableDatabase().setTransactionSuccessful();
    }

    @WorkerThread
    public final void endTransaction() {
        this.zzah();
        this.getWritableDatabase().endTransaction();
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray) {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.rawQuery(string, stringArray);
            if (cursor.moveToFirst()) {
                long l = cursor.getLong(0);
                return l;
            }
            try {
                throw new SQLiteException("Database returned empty set");
            }
            catch (SQLiteException sQLiteException) {
                this.zzad().zzda().zza("Database error", (Object)string, (Object)sQLiteException);
                throw sQLiteException;
            }
        }
    }

    @WorkerThread
    private final long zza(String string, String[] stringArray, long l) {
        long l2;
        block7: {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            try (Cursor cursor = null;){
                cursor = sQLiteDatabase.rawQuery(string, stringArray);
                if (cursor.moveToFirst()) {
                    long l3 = cursor.getLong(0);
                    return l3;
                }
                l2 = l;
                if (cursor == null) break block7;
            }
            cursor.close();
        }
        return l2;
    }

    @VisibleForTesting
    @WorkerThread
    final SQLiteDatabase getWritableDatabase() {
        this.zzq();
        try {
            return this.zzej.getWritableDatabase();
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzdd().zza("Error opening database", (Object)sQLiteException);
            throw sQLiteException;
        }
    }

    @WorkerThread
    public final zzaf zzc(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("events", new String[]{"lifetime_count", "current_bundle_count", "last_fire_timestamp", "last_bundled_timestamp", "last_bundled_day", "last_sampled_complex_event_id", "last_sampling_rate", "last_exempt_from_sampling"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            long l2 = cursor.getLong(1);
            long l3 = cursor.getLong(2);
            long l4 = cursor.isNull(3) ? 0L : cursor.getLong(3);
            Long l5 = cursor.isNull(4) ? null : Long.valueOf(cursor.getLong(4));
            Long l6 = cursor.isNull(5) ? null : Long.valueOf(cursor.getLong(5));
            Long l7 = cursor.isNull(6) ? null : Long.valueOf(cursor.getLong(6));
            Boolean bl = null;
            if (!cursor.isNull(7)) {
                bl = cursor.getLong(7) == 1L;
            }
            zzaf zzaf2 = new zzaf(string, string2, l, l2, l3, l4, l5, l6, l7, bl);
            if (cursor.moveToNext()) {
                this.zzad().zzda().zza("Got multiple records for event aggregates, expected one. appId", zzau.zzao((String)string));
            }
            zzaf zzaf3 = zzaf2;
            return zzaf3;
        }
    }

    @WorkerThread
    public final void zza(zzaf zzaf2) {
        Preconditions.checkNotNull((Object)zzaf2);
        this.zzq();
        this.zzah();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzaf2.zzcf);
        contentValues.put("name", zzaf2.name);
        contentValues.put("lifetime_count", Long.valueOf(zzaf2.zzfe));
        contentValues.put("current_bundle_count", Long.valueOf(zzaf2.zzff));
        contentValues.put("last_fire_timestamp", Long.valueOf(zzaf2.zzfg));
        contentValues.put("last_bundled_timestamp", Long.valueOf(zzaf2.zzfh));
        contentValues.put("last_bundled_day", zzaf2.zzfi);
        contentValues.put("last_sampled_complex_event_id", zzaf2.zzfj);
        contentValues.put("last_sampling_rate", zzaf2.zzfk);
        Long l = null;
        if (zzaf2.zzfl != null && zzaf2.zzfl.booleanValue()) {
            l = 1L;
        }
        contentValues.put("last_exempt_from_sampling", l);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("events", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert/update event aggregates (got -1). appId", zzau.zzao((String)zzaf2.zzcf));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing event aggregates. appId", zzau.zzao((String)zzaf2.zzcf), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final void zzd(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzq();
        this.zzah();
        try {
            int n = this.getWritableDatabase().delete("user_attributes", "app_id=? and name=?", new String[]{string, string2});
            this.zzad().zzdi().zza("Deleted user attribute rows", (Object)n);
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error deleting user attribute. appId", zzau.zzao((String)string), (Object)this.zzaa().zzan(string2), (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zza(zzgc zzgc2) {
        Preconditions.checkNotNull((Object)zzgc2);
        this.zzq();
        this.zzah();
        if (this.zze(zzgc2.zzcf, zzgc2.name) == null && (zzgd.zzbm((String)zzgc2.name) ? this.zza("select count(1) from user_attributes where app_id=? and name not like '!_%' escape '!'", new String[]{zzgc2.zzcf}) >= 25L : (this.zzaf().zze(zzgc2.zzcf, zzal.zzin) ? !"_npa".equals(zzgc2.name) && this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzgc2.zzcf, zzgc2.origin}) >= 25L : this.zza("select count(1) from user_attributes where app_id=? and origin=? AND name like '!_%' escape '!'", new String[]{zzgc2.zzcf, zzgc2.origin}) >= 25L))) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzgc2.zzcf);
        contentValues.put("origin", zzgc2.origin);
        contentValues.put("name", zzgc2.name);
        contentValues.put("set_timestamp", Long.valueOf(zzgc2.zzsx));
        zzw.zza(contentValues, "value", zzgc2.value);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("user_attributes", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert/update user property (got -1). appId", zzau.zzao((String)zzgc2.zzcf));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing user property. appId", zzau.zzao((String)zzgc2.zzcf), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzgc zze(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"set_timestamp", "value", "origin"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            long l = cursor.getLong(0);
            Object object = this.zza(cursor, 1);
            String string3 = cursor.getString(2);
            zzgc zzgc2 = new zzgc(string, string3, string2, l, object);
            if (cursor.moveToNext()) {
                this.zzad().zzda().zza("Got multiple records for user property, expected one. appId", zzau.zzao((String)string));
            }
            zzgc zzgc3 = zzgc2;
            return zzgc3;
        }
    }

    @WorkerThread
    public final List<zzgc> zzad(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        ArrayList<zzgc> arrayList = new ArrayList<zzgc>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "origin", "set_timestamp", "value"}, "app_id=?", new String[]{string}, null, null, "rowid", "1000");
            if (!cursor.moveToFirst()) {
                ArrayList<zzgc> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                if (string2 == null) {
                    string2 = "";
                }
                long l = cursor.getLong(2);
                Object object2 = this.zza(cursor, 3);
                if (object2 == null) {
                    this.zzad().zzda().zza("Read invalid user property value, ignoring it. appId", zzau.zzao((String)string));
                    continue;
                }
                zzgc zzgc2 = new zzgc(string, string2, (String)object, l, object2);
                arrayList.add(zzgc2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final List<zzgc> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        ArrayList<zzgc> arrayList = new ArrayList<zzgc>();
        try (Cursor cursor = null;){
            Object object;
            ArrayList<String> arrayList2 = new ArrayList<String>(3);
            arrayList2.add(string);
            StringBuilder stringBuilder = new StringBuilder("app_id=?");
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                arrayList2.add(string2);
                stringBuilder.append(" and origin=?");
            }
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                arrayList2.add(String.valueOf(string3).concat("*"));
                stringBuilder.append(" and name glob ?");
            }
            String[] stringArray = arrayList2.toArray(new String[arrayList2.size()]);
            cursor = this.getWritableDatabase().query("user_attributes", new String[]{"name", "set_timestamp", "value", "origin"}, stringBuilder.toString(), stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzgc> arrayList3 = arrayList;
                return arrayList3;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzad().zzda().zza("Read more than the max allowed user properties, ignoring excess", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                long l = cursor.getLong(1);
                Object object2 = this.zza(cursor, 2);
                string2 = cursor.getString(3);
                if (object2 == null) {
                    this.zzad().zzda().zza("(2)Read invalid user property value, ignoring it", zzau.zzao((String)string), (Object)string2, (Object)string3);
                    continue;
                }
                zzgc zzgc2 = new zzgc(string, string2, (String)object, l, object2);
                arrayList.add(zzgc2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final boolean zza(zzr zzr2) {
        Preconditions.checkNotNull((Object)zzr2);
        this.zzq();
        this.zzah();
        if (this.zze(zzr2.packageName, zzr2.zzdv.name) == null && this.zza("SELECT COUNT(1) FROM conditional_properties WHERE app_id=?", new String[]{zzr2.packageName}) >= 1000L) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzr2.packageName);
        contentValues.put("origin", zzr2.origin);
        contentValues.put("name", zzr2.zzdv.name);
        zzw.zza(contentValues, "value", zzr2.zzdv.getValue());
        contentValues.put("active", Boolean.valueOf(zzr2.active));
        contentValues.put("trigger_event_name", zzr2.triggerEventName);
        contentValues.put("trigger_timeout", Long.valueOf(zzr2.triggerTimeout));
        this.zzab();
        contentValues.put("timed_out_event", zzgd.zza((Parcelable)zzr2.zzdw));
        contentValues.put("creation_timestamp", Long.valueOf(zzr2.creationTimestamp));
        this.zzab();
        contentValues.put("triggered_event", zzgd.zza((Parcelable)zzr2.zzdx));
        contentValues.put("triggered_timestamp", Long.valueOf(zzr2.zzdv.zzsx));
        contentValues.put("time_to_live", Long.valueOf(zzr2.timeToLive));
        this.zzab();
        contentValues.put("expired_event", zzgd.zza((Parcelable)zzr2.zzdy));
        try {
            if (this.getWritableDatabase().insertWithOnConflict("conditional_properties", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert/update conditional user property (got -1)", zzau.zzao((String)zzr2.packageName));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing conditional user property", zzau.zzao((String)zzr2.packageName), (Object)sQLiteException);
        }
        return true;
    }

    @WorkerThread
    public final zzr zzf(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"origin", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, "app_id=? and name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            String string3 = cursor.getString(0);
            Object object = this.zza(cursor, 1);
            boolean bl = cursor.getInt(2) != 0;
            String string4 = cursor.getString(3);
            long l = cursor.getLong(4);
            zzaj zzaj2 = (zzaj)this.zzdm().zza(cursor.getBlob(5), zzaj.CREATOR);
            long l2 = cursor.getLong(6);
            zzaj zzaj3 = (zzaj)this.zzdm().zza(cursor.getBlob(7), zzaj.CREATOR);
            long l3 = cursor.getLong(8);
            long l4 = cursor.getLong(9);
            zzaj zzaj4 = (zzaj)this.zzdm().zza(cursor.getBlob(10), zzaj.CREATOR);
            zzga zzga2 = new zzga(string2, l3, object, string3);
            zzr zzr2 = new zzr(string, string3, zzga2, l2, bl, string4, zzaj2, l, zzaj3, l4, zzaj4);
            if (cursor.moveToNext()) {
                this.zzad().zzda().zza("Got multiple records for conditional property, expected one", zzau.zzao((String)string), (Object)this.zzaa().zzan(string2));
            }
            zzr zzr3 = zzr2;
            return zzr3;
        }
    }

    @WorkerThread
    public final int zzg(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzq();
        this.zzah();
        try {
            return this.getWritableDatabase().delete("conditional_properties", "app_id=? and name=?", new String[]{string, string2});
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error deleting conditional property", zzau.zzao((String)string), (Object)this.zzaa().zzan(string2), (Object)sQLiteException);
            return 0;
        }
    }

    @WorkerThread
    public final List<zzr> zzb(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        ArrayList<String> arrayList = new ArrayList<String>(3);
        arrayList.add(string);
        StringBuilder stringBuilder = new StringBuilder("app_id=?");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
            stringBuilder.append(" and origin=?");
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            arrayList.add(String.valueOf(string3).concat("*"));
            stringBuilder.append(" and name glob ?");
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        return this.zzb(stringBuilder.toString(), stringArray);
    }

    public final List<zzr> zzb(String string, String[] stringArray) {
        this.zzq();
        this.zzah();
        ArrayList<zzr> arrayList = new ArrayList<zzr>();
        try (Cursor cursor = null;){
            Object object;
            cursor = this.getWritableDatabase().query("conditional_properties", new String[]{"app_id", "origin", "name", "value", "active", "trigger_event_name", "trigger_timeout", "timed_out_event", "creation_timestamp", "triggered_event", "triggered_timestamp", "time_to_live", "expired_event"}, string, stringArray, null, null, "rowid", "1001");
            if (!cursor.moveToFirst()) {
                ArrayList<zzr> arrayList2 = arrayList;
                return arrayList2;
            }
            do {
                if (arrayList.size() >= 1000) {
                    this.zzad().zzda().zza("Read more than the max allowed conditional properties, ignoring extra", (Object)1000);
                    break;
                }
                object = cursor.getString(0);
                String string2 = cursor.getString(1);
                String string3 = cursor.getString(2);
                Object object2 = this.zza(cursor, 3);
                boolean bl = cursor.getInt(4) != 0;
                String string4 = cursor.getString(5);
                long l = cursor.getLong(6);
                zzaj zzaj2 = (zzaj)this.zzdm().zza(cursor.getBlob(7), zzaj.CREATOR);
                long l2 = cursor.getLong(8);
                zzaj zzaj3 = (zzaj)this.zzdm().zza(cursor.getBlob(9), zzaj.CREATOR);
                long l3 = cursor.getLong(10);
                long l4 = cursor.getLong(11);
                zzaj zzaj4 = (zzaj)this.zzdm().zza(cursor.getBlob(12), zzaj.CREATOR);
                zzga zzga2 = new zzga(string3, l3, object2, string2);
                zzr zzr2 = new zzr((String)object, string2, zzga2, l2, bl, string4, zzaj2, l, zzaj3, l4, zzaj4);
                arrayList.add(zzr2);
            } while (cursor.moveToNext());
            object = arrayList;
            return object;
        }
    }

    @WorkerThread
    public final zzg zzae(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"app_instance_id", "gmp_app_id", "resettable_device_id_hash", "last_bundle_index", "last_bundle_start_timestamp", "last_bundle_end_timestamp", "app_version", "app_store", "gmp_version", "dev_cert_hash", "measurement_enabled", "day", "daily_public_events_count", "daily_events_count", "daily_conversions_count", "config_fetched_time", "failed_config_fetch_time", "app_version_int", "firebase_instance_id", "daily_error_events_count", "daily_realtime_events_count", "health_monitor_sample", "android_id", "adid_reporting_enabled", "ssaid_reporting_enabled", "admob_app_id", "dynamite_version"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            zzg zzg2 = new zzg(this.zzkt.zzgi(), string);
            zzg2.zza(cursor.getString(0));
            zzg2.zzb(cursor.getString(1));
            zzg2.zzd(cursor.getString(2));
            zzg2.zzk(cursor.getLong(3));
            zzg2.zze(cursor.getLong(4));
            zzg2.zzf(cursor.getLong(5));
            zzg2.zzf(cursor.getString(6));
            zzg2.zzg(cursor.getString(7));
            zzg2.zzh(cursor.getLong(8));
            zzg2.zzi(cursor.getLong(9));
            zzg2.setMeasurementEnabled(cursor.isNull(10) || cursor.getInt(10) != 0);
            zzg2.zzn(cursor.getLong(11));
            zzg2.zzo(cursor.getLong(12));
            zzg2.zzp(cursor.getLong(13));
            zzg2.zzq(cursor.getLong(14));
            zzg2.zzl(cursor.getLong(15));
            zzg2.zzm(cursor.getLong(16));
            zzg2.zzg(cursor.isNull(17) ? Integer.MIN_VALUE : (long)cursor.getInt(17));
            zzg2.zze(cursor.getString(18));
            zzg2.zzs(cursor.getLong(19));
            zzg2.zzr(cursor.getLong(20));
            zzg2.zzh(cursor.getString(21));
            zzg2.zzt(cursor.isNull(22) ? 0L : cursor.getLong(22));
            zzg2.zzb(cursor.isNull(23) || cursor.getInt(23) != 0);
            zzg2.zzc(cursor.isNull(24) || cursor.getInt(24) != 0);
            zzg2.zzc(cursor.getString(25));
            zzg2.zzj(cursor.isNull(26) ? 0L : cursor.getLong(26));
            zzg2.zzam();
            if (cursor.moveToNext()) {
                this.zzad().zzda().zza("Got multiple records for app, expected one. appId", zzau.zzao((String)string));
            }
            zzg zzg3 = zzg2;
            return zzg3;
        }
    }

    @WorkerThread
    public final void zza(zzg zzg2) {
        Preconditions.checkNotNull((Object)zzg2);
        this.zzq();
        this.zzah();
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzg2.zzan());
        contentValues.put("app_instance_id", zzg2.getAppInstanceId());
        contentValues.put("gmp_app_id", zzg2.getGmpAppId());
        contentValues.put("resettable_device_id_hash", zzg2.zzap());
        contentValues.put("last_bundle_index", Long.valueOf(zzg2.zzay()));
        contentValues.put("last_bundle_start_timestamp", Long.valueOf(zzg2.zzaq()));
        contentValues.put("last_bundle_end_timestamp", Long.valueOf(zzg2.zzar()));
        contentValues.put("app_version", zzg2.zzas());
        contentValues.put("app_store", zzg2.zzau());
        contentValues.put("gmp_version", Long.valueOf(zzg2.zzav()));
        contentValues.put("dev_cert_hash", Long.valueOf(zzg2.zzaw()));
        contentValues.put("measurement_enabled", Boolean.valueOf(zzg2.isMeasurementEnabled()));
        contentValues.put("day", Long.valueOf(zzg2.zzbc()));
        contentValues.put("daily_public_events_count", Long.valueOf(zzg2.zzbd()));
        contentValues.put("daily_events_count", Long.valueOf(zzg2.zzbe()));
        contentValues.put("daily_conversions_count", Long.valueOf(zzg2.zzbf()));
        contentValues.put("config_fetched_time", Long.valueOf(zzg2.zzaz()));
        contentValues.put("failed_config_fetch_time", Long.valueOf(zzg2.zzba()));
        contentValues.put("app_version_int", Long.valueOf(zzg2.zzat()));
        contentValues.put("firebase_instance_id", zzg2.getFirebaseInstanceId());
        contentValues.put("daily_error_events_count", Long.valueOf(zzg2.zzbh()));
        contentValues.put("daily_realtime_events_count", Long.valueOf(zzg2.zzbg()));
        contentValues.put("health_monitor_sample", zzg2.zzbi());
        contentValues.put("android_id", Long.valueOf(zzg2.zzbk()));
        contentValues.put("adid_reporting_enabled", Boolean.valueOf(zzg2.zzbl()));
        contentValues.put("ssaid_reporting_enabled", Boolean.valueOf(zzg2.zzbm()));
        contentValues.put("admob_app_id", zzg2.zzao());
        contentValues.put("dynamite_version", Long.valueOf(zzg2.zzax()));
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            if ((long)sQLiteDatabase.update("apps", contentValues, "app_id = ?", new String[]{zzg2.zzan()}) == 0L && sQLiteDatabase.insertWithOnConflict("apps", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert/update app (got -1). appId", zzau.zzao((String)zzg2.zzan()));
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing app. appId", zzau.zzao((String)zzg2.zzan()), (Object)sQLiteException);
            return;
        }
    }

    public final long zzaf(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        try {
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            String string2 = string;
            int n = this.zzaf().zzb(string2, zzal.zzgs);
            n = Math.min(1000000, n);
            String string3 = String.valueOf(Math.max(0, n));
            return sQLiteDatabase.delete("raw_events", "rowid in (select rowid from raw_events where app_id=? order by rowid desc limit -1 offset ?)", new String[]{string, string3});
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error deleting over the limit events. appId", zzau.zzao((String)string), (Object)sQLiteException);
            return 0L;
        }
    }

    @WorkerThread
    public final zzx zza(long l, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        String[] stringArray = new String[]{string};
        zzx zzx2 = new zzx();
        try (Cursor cursor = null;){
            SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
            cursor = sQLiteDatabase.query("apps", new String[]{"day", "daily_events_count", "daily_public_events_count", "daily_conversions_count", "daily_error_events_count", "daily_realtime_events_count"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                this.zzad().zzdd().zza("Not updating daily counts, app is not known. appId", zzau.zzao((String)string));
                zzx zzx3 = zzx2;
                return zzx3;
            }
            if (cursor.getLong(0) == l) {
                zzx2.zzem = cursor.getLong(1);
                zzx2.zzel = cursor.getLong(2);
                zzx2.zzen = cursor.getLong(3);
                zzx2.zzeo = cursor.getLong(4);
                zzx2.zzep = cursor.getLong(5);
            }
            if (bl) {
                ++zzx2.zzem;
            }
            if (bl2) {
                ++zzx2.zzel;
            }
            if (bl3) {
                ++zzx2.zzen;
            }
            if (bl4) {
                ++zzx2.zzeo;
            }
            if (bl5) {
                ++zzx2.zzep;
            }
            ContentValues contentValues = new ContentValues();
            contentValues.put("day", Long.valueOf(l));
            contentValues.put("daily_public_events_count", Long.valueOf(zzx2.zzel));
            contentValues.put("daily_events_count", Long.valueOf(zzx2.zzem));
            contentValues.put("daily_conversions_count", Long.valueOf(zzx2.zzen));
            contentValues.put("daily_error_events_count", Long.valueOf(zzx2.zzeo));
            contentValues.put("daily_realtime_events_count", Long.valueOf(zzx2.zzep));
            sQLiteDatabase.update("apps", contentValues, "app_id=?", stringArray);
            zzx zzx4 = zzx2;
            return zzx4;
        }
    }

    @WorkerThread
    public final byte[] zzag(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("apps", new String[]{"remote_config"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            if (cursor.moveToNext()) {
                this.zzad().zzda().zza("Got multiple records for app config, expected one. appId", zzau.zzao((String)string));
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
    }

    @WorkerThread
    public final boolean zza(zzch zzch2, boolean bl) {
        this.zzq();
        this.zzah();
        Preconditions.checkNotNull((Object)zzch2);
        Preconditions.checkNotEmpty((String)zzch2.zzcf);
        Preconditions.checkNotNull((Object)zzch2.zzxs);
        this.zzca();
        long l = this.zzz().currentTimeMillis();
        if (zzch2.zzxs < l - zzt.zzbs() || zzch2.zzxs > l + zzt.zzbs()) {
            this.zzad().zzdd().zza("Storing bundle outside of the max uploading time span. appId, now, timestamp", zzau.zzao((String)zzch2.zzcf), (Object)l, (Object)zzch2.zzxs);
        }
        byte[] byArray = zziv.zzb(zzch2);
        try {
            byArray = this.zzdm().zzc(byArray);
        }
        catch (IOException iOException) {
            this.zzad().zzda().zza("Data loss. Failed to serialize bundle. appId", zzau.zzao((String)zzch2.zzcf), (Object)iOException);
            return false;
        }
        this.zzad().zzdi().zza("Saving bundle, size", (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzch2.zzcf);
        contentValues.put("bundle_end_timestamp", zzch2.zzxs);
        contentValues.put("data", byArray);
        contentValues.put("has_realtime", Integer.valueOf(bl ? 1 : 0));
        if (zzch2.zzyp != null) {
            contentValues.put("retry_count", zzch2.zzyp);
        }
        try {
            if (this.getWritableDatabase().insert("queue", null, contentValues) == -1L) {
                this.zzad().zzda().zza("Failed to insert bundle (got -1). appId", zzau.zzao((String)zzch2.zzcf));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing bundle. appId", zzau.zzao((String)zzch2.zzcf), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final String zzby() {
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        Cursor cursor = null;
        try {
            String string = "select app_id from queue order by has_realtime desc, rowid asc limit 1;";
            cursor = sQLiteDatabase.rawQuery(string, null);
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(0);
                return string2;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Database error getting next bundle app id", (Object)sQLiteException);
            return null;
        }
        if (cursor == null) return null;
        cursor.close();
        return null;
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public final boolean zzbz() {
        return this.zza("select count(1) > 0 from queue where has_realtime = 1", (String[])null) != 0L;
    }

    @WorkerThread
    public final List<Pair<zzch, Long>> zza(String string, int n, int n2) {
        this.zzq();
        this.zzah();
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0);
        Preconditions.checkNotEmpty((String)string);
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().query("queue", new String[]{"rowid", "data", "retry_count"}, "app_id=?", new String[]{string}, null, null, "rowid", String.valueOf(n));
            if (!cursor.moveToFirst()) {
                List<Pair<zzch, Long>> list = Collections.emptyList();
                return list;
            }
            ArrayList<Pair<zzch, Long>> arrayList = new ArrayList<Pair<zzch, Long>>();
            int n3 = 0;
            do {
                byte[] byArray;
                Object object;
                long l = cursor.getLong(0);
                try {
                    object = cursor.getBlob(1);
                    byArray = this.zzdm().zzb((byte[])object);
                }
                catch (IOException iOException) {
                    this.zzad().zzda().zza("Failed to unzip queued bundle. appId", zzau.zzao((String)string), (Object)iOException);
                    continue;
                }
                if (!arrayList.isEmpty() && n3 + byArray.length > n2) break;
                try {
                    object = zzch.zzf(byArray);
                }
                catch (IOException iOException) {
                    this.zzad().zzda().zza("Failed to merge queued bundle. appId", zzau.zzao((String)string), (Object)iOException);
                    continue;
                }
                if (!cursor.isNull(2)) {
                    object.zzyp = cursor.getInt(2);
                }
                n3 += byArray.length;
                arrayList.add((Pair<zzch, Long>)Pair.create((Object)object, (Object)l));
            } while (cursor.moveToNext() && n3 <= n2);
            ArrayList<Pair<zzch, Long>> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    @WorkerThread
    final void zzca() {
        this.zzq();
        this.zzah();
        if (!this.zzcg()) {
            return;
        }
        long l = this.zzae().zzle.get();
        long l2 = this.zzz().elapsedRealtime();
        if (Math.abs(l2 - l) > (Long)zzal.zzhb.get(null)) {
            this.zzae().zzle.set(l2);
            zzw zzw2 = this;
            zzw2.zzq();
            zzw2.zzah();
            if (zzw2.zzcg()) {
                SQLiteDatabase sQLiteDatabase = zzw2.getWritableDatabase();
                String[] stringArray = new String[]{String.valueOf(zzw2.zzz().currentTimeMillis()), String.valueOf(zzt.zzbs())};
                int n = sQLiteDatabase.delete("queue", "abs(bundle_end_timestamp - ?) > cast(? as integer)", stringArray);
                if (n > 0) {
                    zzw2.zzad().zzdi().zza("Deleted stale rows. rowsDeleted", (Object)n);
                }
            }
        }
    }

    @VisibleForTesting
    @WorkerThread
    final void zza(List<Long> list) {
        this.zzq();
        this.zzah();
        Preconditions.checkNotNull(list);
        Preconditions.checkNotZero((int)list.size());
        if (!this.zzcg()) {
            return;
        }
        String string = TextUtils.join((CharSequence)",", list);
        String string2 = new StringBuilder(2 + String.valueOf(string).length()).append("(").append(string).append(")").toString();
        if (this.zza(new StringBuilder(80 + String.valueOf(string2).length()).append("SELECT COUNT(1) FROM queue WHERE rowid IN ").append(string2).append(" AND retry_count =  2147483647 LIMIT 1").toString(), (String[])null) > 0L) {
            this.zzad().zzdd().zzaq("The number of upload retries exceeds the limit. Will remain unchanged.");
        }
        try {
            this.getWritableDatabase().execSQL(new StringBuilder(127 + String.valueOf(string2).length()).append("UPDATE queue SET retry_count = IFNULL(retry_count, 0) + 1 WHERE rowid IN ").append(string2).append(" AND (retry_count IS NULL OR retry_count < 2147483647)").toString());
            return;
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error incrementing retry count. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    final void zza(String string, zzbx[] zzbxArray) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzbxArray);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            int n;
            String string2 = string;
            zzw zzw2 = this;
            zzw2.zzah();
            zzw2.zzq();
            Preconditions.checkNotEmpty((String)string2);
            Object object = zzw2.getWritableDatabase();
            object.delete("property_filters", "app_id=?", new String[]{string2});
            object.delete("event_filters", "app_id=?", new String[]{string2});
            Object object2 = zzbxArray;
            int n2 = zzbxArray.length;
            block3: for (n = 0; n < n2; ++n) {
                zzip zzip2;
                int n3;
                int n4;
                zzbx zzbx2 = object2[n];
                object = zzbx2;
                string2 = string;
                zzw2 = this;
                zzw2.zzah();
                zzw2.zzq();
                Preconditions.checkNotEmpty((String)string2);
                Preconditions.checkNotNull((Object)object);
                Preconditions.checkNotNull((Object)object.zzvw);
                Preconditions.checkNotNull((Object)object.zzvv);
                if (object.zzvu == null) {
                    zzw2.zzad().zzdd().zza("Audience with no ID. appId", zzau.zzao((String)string2));
                    continue;
                }
                int n5 = object.zzvu;
                zzip[] zzipArray = object.zzvw;
                int n6 = object.zzvw.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (zzipArray[n4].zzwa != null) continue;
                    zzw2.zzad().zzdd().zza("Event filter with no ID. Audience definition ignored. appId, audienceId", zzau.zzao((String)string2), (Object)object.zzvu);
                    continue block3;
                }
                zzipArray = object.zzvv;
                n6 = object.zzvv.length;
                for (n4 = 0; n4 < n6; ++n4) {
                    if (((zzcb)zzipArray[n4]).zzwa != null) continue;
                    zzw2.zzad().zzdd().zza("Property filter with no ID. Audience definition ignored. appId, audienceId", zzau.zzao((String)string2), (Object)object.zzvu);
                    continue block3;
                }
                boolean bl = true;
                zzip[] zzipArray2 = object.zzvw;
                n4 = object.zzvw.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    zzip2 = zzipArray2[n3];
                    if (zzw2.zza(string2, n5, (zzby)zzip2)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    zzipArray2 = object.zzvv;
                    n4 = object.zzvv.length;
                    for (n3 = 0; n3 < n4; ++n3) {
                        zzip2 = zzipArray2[n3];
                        if (zzw2.zza(string2, n5, (zzcb)zzip2)) continue;
                        bl = false;
                        break;
                    }
                }
                if (bl) continue;
                int n7 = n5;
                String string3 = string2;
                zzw zzw3 = zzw2;
                zzw3.zzah();
                zzw3.zzq();
                Preconditions.checkNotEmpty((String)string3);
                SQLiteDatabase sQLiteDatabase2 = zzw3.getWritableDatabase();
                sQLiteDatabase2.delete("property_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
                sQLiteDatabase2.delete("event_filters", "app_id=? and audience_id=?", new String[]{string3, String.valueOf(n7)});
            }
            object2 = new ArrayList();
            zzbx[] zzbxArray2 = zzbxArray;
            n = zzbxArray.length;
            for (int i = 0; i < n; ++i) {
                zzbx zzbx3 = zzbxArray2[i];
                object2.add(zzbx3.zzvu);
            }
            this.zza(string, (List<Integer>)object2);
            sQLiteDatabase.setTransactionSuccessful();
            return;
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzby zzby2) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzby2);
        if (TextUtils.isEmpty((CharSequence)zzby2.zzwb)) {
            this.zzad().zzdd().zza("Event filter had no event name. Audience definition ignored. appId, audienceId, filterId", zzau.zzao((String)string), (Object)n, (Object)String.valueOf(zzby2.zzwa));
            return false;
        }
        byte[] byArray = zziv.zzb(zzby2);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzby2.zzwa);
        contentValues.put("event_name", zzby2.zzwb);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("event_filters", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert event filter (got -1). appId", zzau.zzao((String)string));
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing event filter. appId", zzau.zzao((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    @WorkerThread
    private final boolean zza(String string, int n, zzcb zzcb2) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)zzcb2);
        if (TextUtils.isEmpty((CharSequence)zzcb2.zzwq)) {
            this.zzad().zzdd().zza("Property filter had no property name. Audience definition ignored. appId, audienceId, filterId", zzau.zzao((String)string), (Object)n, (Object)String.valueOf(zzcb2.zzwa));
            return false;
        }
        byte[] byArray = zziv.zzb(zzcb2);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("audience_id", Integer.valueOf(n));
        contentValues.put("filter_id", zzcb2.zzwa);
        contentValues.put("property_name", zzcb2.zzwq);
        contentValues.put("data", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("property_filters", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert property filter (got -1). appId", zzau.zzao((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing property filter. appId", zzau.zzao((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    final Map<Integer, List<zzby>> zzh(String string, String string2) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("event_filters", new String[]{"audience_id", "data"}, "app_id=? AND event_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzby>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzby zzby2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    byte[] byArray2 = byArray;
                    zzby2 = zziv.zza(new zzby(), byArray2);
                }
                catch (IOException iOException) {
                    this.zzad().zzda().zza("Failed to merge filter. appId", zzau.zzao((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzby> arrayList = (ArrayList<zzby>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzby>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzby2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    final Map<Integer, List<zzcb>> zzi(String string, String string2) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ArrayMap arrayMap = new ArrayMap();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("property_filters", new String[]{"audience_id", "data"}, "app_id=? AND property_name=?", new String[]{string, string2}, null, null, null);
            if (!cursor.moveToFirst()) {
                Map<Integer, List<zzcb>> map = Collections.emptyMap();
                return map;
            }
            do {
                zzcb zzcb2;
                byte[] byArray = cursor.getBlob(1);
                try {
                    byte[] byArray2 = byArray;
                    zzcb2 = zziv.zza(new zzcb(), byArray2);
                }
                catch (IOException iOException) {
                    this.zzad().zzda().zza("Failed to merge filter", zzau.zzao((String)string), (Object)iOException);
                    continue;
                }
                int n = cursor.getInt(0);
                ArrayList<zzcb> arrayList = (ArrayList<zzcb>)arrayMap.get(n);
                if (arrayList == null) {
                    arrayList = new ArrayList<zzcb>();
                    arrayMap.put(n, arrayList);
                }
                arrayList.add(zzcb2);
            } while (cursor.moveToNext());
        }
        return arrayMap;
    }

    private final boolean zza(String string, List<Integer> list) {
        Object object;
        long l;
        Preconditions.checkNotEmpty((String)string);
        this.zzah();
        this.zzq();
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try {
            l = this.zza("select count(1) from audience_filter_values where app_id=?", new String[]{string});
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Database error querying filters. appId", zzau.zzao((String)string), (Object)sQLiteException);
            return false;
        }
        String string2 = string;
        int n = this.zzaf().zzb(string2, zzal.zzhi);
        n = Math.min(2000, n);
        int n2 = Math.max(0, n);
        if (l <= (long)n2) {
            return false;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            if (object == null || !(object instanceof Integer)) {
                return false;
            }
            arrayList.add(Integer.toString((Integer)object));
        }
        object = TextUtils.join((CharSequence)",", arrayList);
        String string3 = new StringBuilder(2 + String.valueOf(object).length()).append("(").append((String)object).append(")").toString();
        return sQLiteDatabase.delete("audience_filter_values", new StringBuilder(140 + String.valueOf(string3).length()).append("audience_id in (select audience_id from audience_filter_values where app_id=? and audience_id not in ").append(string3).append(" order by rowid desc limit -1 offset ?)").toString(), new String[]{string, Integer.toString(n2)}) > 0;
    }

    final Map<Integer, zzbt.zzf> zzah(String string) {
        this.zzah();
        this.zzq();
        Preconditions.checkNotEmpty((String)string);
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        try (Cursor cursor = null;){
            cursor = sQLiteDatabase.query("audience_filter_values", new String[]{"audience_id", "current_results"}, "app_id=?", new String[]{string}, null, null, null);
            if (!cursor.moveToFirst()) {
                return null;
            }
            ArrayMap arrayMap = new ArrayMap();
            do {
                zzbt.zzf zzf2;
                int n = cursor.getInt(0);
                byte[] byArray = cursor.getBlob(1);
                try {
                    zzf2 = zzbt.zzf.zza(byArray, zzem.zzlt());
                }
                catch (IOException iOException) {
                    this.zzad().zzda().zza("Failed to merge filter results. appId, audienceId, error", zzau.zzao((String)string), (Object)n, (Object)iOException);
                    continue;
                }
                arrayMap.put(n, zzf2);
            } while (cursor.moveToNext());
            ArrayMap arrayMap2 = arrayMap;
            return arrayMap2;
        }
    }

    @WorkerThread
    private static void zza(ContentValues contentValues, String string, Object object) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)object);
        if (object instanceof String) {
            contentValues.put(string, (String)object);
            return;
        }
        if (object instanceof Long) {
            contentValues.put(string, (Long)object);
            return;
        }
        if (object instanceof Double) {
            contentValues.put(string, (Double)object);
            return;
        }
        throw new IllegalArgumentException("Invalid value type");
    }

    @VisibleForTesting
    @WorkerThread
    private final Object zza(Cursor cursor, int n) {
        int n2 = n;
        Cursor cursor2 = cursor;
        int n3 = cursor2.getType(n2);
        switch (n3) {
            case 0: {
                this.zzad().zzda().zzaq("Loaded invalid null value from database");
                return null;
            }
            case 1: {
                return cursor.getLong(n);
            }
            case 2: {
                return cursor.getDouble(n);
            }
            case 3: {
                return cursor.getString(n);
            }
            case 4: {
                this.zzad().zzda().zzaq("Loaded invalid blob type value, ignoring it");
                return null;
            }
        }
        this.zzad().zzda().zza("Loaded invalid unknown value type, ignoring it", (Object)n3);
        return null;
    }

    @WorkerThread
    public final long zzcb() {
        return this.zza("select max(bundle_end_timestamp) from queue", null, 0L);
    }

    @WorkerThread
    @VisibleForTesting
    protected final long zzj(String string, String string2) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        this.zzq();
        this.zzah();
        long l = 0L;
        SQLiteDatabase sQLiteDatabase = this.getWritableDatabase();
        sQLiteDatabase.beginTransaction();
        try {
            ContentValues contentValues;
            l = this.zza(new StringBuilder(32 + String.valueOf(string2).length()).append("select ").append(string2).append(" from app2 where app_id=?").toString(), new String[]{string}, -1L);
            if (l == -1L) {
                l = 0L;
                contentValues = new ContentValues();
                contentValues.put("app_id", string);
                contentValues.put("first_open_count", Integer.valueOf(0));
                contentValues.put("previous_install_count", Integer.valueOf(0));
                if (sQLiteDatabase.insertWithOnConflict("app2", null, contentValues, 5) == -1L) {
                    this.zzad().zzda().zza("Failed to insert column (got -1). appId", zzau.zzao((String)string), (Object)string2);
                    return -1L;
                }
            }
            contentValues = new ContentValues();
            contentValues.put("app_id", string);
            contentValues.put(string2, Long.valueOf(l + 1L));
            if ((long)sQLiteDatabase.update("app2", contentValues, "app_id = ?", new String[]{string}) == 0L) {
                this.zzad().zzda().zza("Failed to update column (got 0). appId", zzau.zzao((String)string), (Object)string2);
                return -1L;
            }
            sQLiteDatabase.setTransactionSuccessful();
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error inserting column. appId", zzau.zzao((String)string), (Object)string2, (Object)sQLiteException);
        }
        finally {
            sQLiteDatabase.endTransaction();
        }
        return l;
    }

    @WorkerThread
    public final long zzcc() {
        return this.zza("select max(timestamp) from raw_events", null, 0L);
    }

    public final long zza(zzch zzch2) throws IOException {
        this.zzq();
        this.zzah();
        Preconditions.checkNotNull((Object)zzch2);
        Preconditions.checkNotEmpty((String)zzch2.zzcf);
        byte[] byArray = zziv.zzb(zzch2);
        long l = this.zzdm().zza(byArray);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", zzch2.zzcf);
        contentValues.put("metadata_fingerprint", Long.valueOf(l));
        contentValues.put("metadata", byArray);
        try {
            this.getWritableDatabase().insertWithOnConflict("raw_events_metadata", null, contentValues, 4);
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing raw event metadata. appId", zzau.zzao((String)zzch2.zzcf), (Object)sQLiteException);
            throw sQLiteException;
        }
        return l;
    }

    public final boolean zzcd() {
        return this.zza("select count(1) > 0 from raw_events", (String[])null) != 0L;
    }

    public final boolean zzce() {
        return this.zza("select count(1) > 0 from raw_events where realtime = 1", (String[])null) != 0L;
    }

    public final long zzai(String string) {
        Preconditions.checkNotEmpty((String)string);
        return this.zza("select count(1) from events where app_id=? and name not like '!_%' escape '!'", new String[]{string}, 0L);
    }

    public final String zzu(long l) {
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select app_id from apps where app_id in (select distinct app_id from raw_events) and config_fetched_time < ? order by failed_config_fetch_time limit 1;", new String[]{String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzad().zzdi().zzaq("No expired configs for apps with pending events");
                return null;
            }
            String string = cursor.getString(0);
            return string;
        }
        return null;
    }

    public final long zzcf() {
        try (Cursor cursor = null;){
            cursor = this.getWritableDatabase().rawQuery("select rowid from raw_events order by rowid desc limit 1;", null);
            if (!cursor.moveToFirst()) {
                return -1L;
            }
            long l = cursor.getLong(0);
            return l;
        }
        return -1L;
    }

    public final Pair<zzcf, Long> zza(String string, Long l) {
        this.zzq();
        this.zzah();
        try (Cursor cursor = null;){
            zzcf zzcf2;
            cursor = this.getWritableDatabase().rawQuery("select main_event, children_to_process from main_event_params where app_id=? and event_id=?", new String[]{string, String.valueOf(l)});
            if (!cursor.moveToFirst()) {
                this.zzad().zzdi().zzaq("Main event not found");
                return null;
            }
            byte[] byArray = cursor.getBlob(0);
            Long l2 = cursor.getLong(1);
            try {
                zzcf2 = zzcf.zze(byArray);
            }
            catch (IOException iOException) {
                this.zzad().zzda().zza("Failed to merge main event. appId, eventId", zzau.zzao((String)string), (Object)l, (Object)iOException);
                if (cursor != null) {
                    cursor.close();
                }
                return null;
            }
            Pair pair = Pair.create((Object)zzcf2, (Object)l2);
            return pair;
        }
        return null;
    }

    public final boolean zza(String string, Long l, long l2, zzcf zzcf2) {
        this.zzq();
        this.zzah();
        Preconditions.checkNotNull((Object)zzcf2);
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)l);
        byte[] byArray = zziv.zzb(zzcf2);
        this.zzad().zzdi().zza("Saving complex main event, appId, data size", (Object)this.zzaa().zzal(string), (Object)byArray.length);
        ContentValues contentValues = new ContentValues();
        contentValues.put("app_id", string);
        contentValues.put("event_id", l);
        contentValues.put("children_to_process", Long.valueOf(l2));
        contentValues.put("main_event", byArray);
        try {
            if (this.getWritableDatabase().insertWithOnConflict("main_event_params", null, contentValues, 5) == -1L) {
                this.zzad().zzda().zza("Failed to insert complex main event (got -1). appId", zzau.zzao((String)string));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing complex main event. appId", zzau.zzao((String)string), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    public final boolean zza(zzae zzae2, long l, boolean bl) {
        String string2;
        this.zzq();
        this.zzah();
        Preconditions.checkNotNull((Object)zzae2);
        Preconditions.checkNotEmpty((String)zzae2.zzcf);
        zzcf zzcf2 = new zzcf();
        new zzcf().zzxk = zzae2.zzfc;
        zzcf2.zzxi = new zzbt.zzd[zzae2.zzfd.size()];
        int n = 0;
        for (String string2 : zzae2.zzfd) {
            zzbt.zzd.zza zza2 = zzbt.zzd.zzht().zzbw(string2);
            Object object = zzae2.zzfd.get(string2);
            this.zzdm().zza(zza2, object);
            zzcf2.zzxi[n++] = (zzbt.zzd)((zzez)zza2.zzmr());
        }
        Object object = zziv.zzb(zzcf2);
        this.zzad().zzdi().zza("Saving event, name, data size", (Object)this.zzaa().zzal(zzae2.name), (Object)((Object)object).length);
        string2 = new ContentValues();
        string2.put("app_id", zzae2.zzcf);
        string2.put("name", zzae2.name);
        string2.put("timestamp", Long.valueOf(zzae2.timestamp));
        string2.put("metadata_fingerprint", Long.valueOf(l));
        string2.put("data", (byte[])object);
        string2.put("realtime", Integer.valueOf(bl ? 1 : 0));
        try {
            if (this.getWritableDatabase().insert("raw_events", null, (ContentValues)string2) == -1L) {
                this.zzad().zzda().zza("Failed to insert raw event (got -1). appId", zzau.zzao((String)zzae2.zzcf));
                return false;
            }
        }
        catch (SQLiteException sQLiteException) {
            this.zzad().zzda().zza("Error storing raw event. appId", zzau.zzao((String)zzae2.zzcf), (Object)sQLiteException);
            return false;
        }
        return true;
    }

    private final boolean zzcg() {
        return this.getContext().getDatabasePath("google_app_measurement.db").exists();
    }

    static /* synthetic */ zzfo zza(zzw zzw2) {
        return zzw2.zzek;
    }

    static /* synthetic */ String[] zzch() {
        return zzed;
    }

    static /* synthetic */ String[] zzci() {
        return zzee;
    }

    static /* synthetic */ String[] zzcj() {
        return zzef;
    }

    static /* synthetic */ String[] zzck() {
        return zzeh;
    }

    static /* synthetic */ String[] zzcl() {
        return zzeg;
    }

    static /* synthetic */ String[] zzcm() {
        return zzei;
    }
}

