/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdmk;
import com.google.android.gms.internal.ads.zzdoc;
import com.google.android.gms.internal.ads.zzdoi;
import com.google.android.gms.internal.ads.zzdpv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdnx
extends zzdmk<Float>
implements zzdoi<Float>,
zzdpv,
RandomAccess {
    private static final zzdnx zzhgz = new zzdnx(new float[0], 0);
    private float[] zzhha;
    private int size;

    zzdnx() {
        this(new float[10], 0);
    }

    private zzdnx(float[] fArray, int n) {
        this.zzhha = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzavk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhha, n2, this.zzhha, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdnx)) {
            return super.equals(object);
        }
        zzdnx zzdnx2 = (zzdnx)object;
        if (this.size != zzdnx2.size) {
            return false;
        }
        float[] fArray = zzdnx2.zzhha;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzhha[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzhha[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzi(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzavk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
        if (this.size < this.zzhha.length) {
            System.arraycopy(this.zzhha, n, this.zzhha, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhha, 0, fArray, 0, n);
            System.arraycopy(this.zzhha, n, fArray, n + 1, this.size - n);
            this.zzhha = fArray;
        }
        this.zzhha[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzavk();
        zzdoc.checkNotNull(collection);
        if (!(collection instanceof zzdnx)) {
            return super.addAll(collection);
        }
        zzdnx zzdnx2 = (zzdnx)collection;
        if (zzdnx2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdnx2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdnx2.size;
        if (n > this.zzhha.length) {
            this.zzhha = Arrays.copyOf(this.zzhha, n);
        }
        System.arraycopy(zzdnx2.zzhha, 0, this.zzhha, this.size, zzdnx2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzavk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzhha[i]))) continue;
            System.arraycopy(this.zzhha, i + 1, this.zzhha, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzdnx zzdnx2 = this;
        zzdnx2.zzavk();
        zzdnx2.zzfj(n);
        float f3 = zzdnx2.zzhha[n];
        zzdnx2.zzhha[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdnx zzdnx2 = this;
        zzdnx2.zzavk();
        zzdnx2.zzfj(n);
        float f = zzdnx2.zzhha[n];
        if (n < zzdnx2.size - 1) {
            System.arraycopy(zzdnx2.zzhha, n + 1, zzdnx2.zzhha, n, zzdnx2.size - n - 1);
        }
        --zzdnx2.size;
        ++zzdnx2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzdoi zzfl(int n) {
        int n2 = n;
        zzdnx zzdnx2 = this;
        if (n2 < zzdnx2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdnx(Arrays.copyOf(zzdnx2.zzhha, n2), zzdnx2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzdnx zzdnx2 = this;
        zzdnx2.zzfj(n);
        return Float.valueOf(zzdnx2.zzhha[n]);
    }

    static {
        zzhgz.zzavj();
    }
}

