/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdmk;
import com.google.android.gms.internal.ads.zzdoc;
import com.google.android.gms.internal.ads.zzdoi;
import com.google.android.gms.internal.ads.zzdpv;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzdox
extends zzdmk<Long>
implements zzdoi<Long>,
zzdpv,
RandomAccess {
    private static final zzdox zzhjd = new zzdox(new long[0], 0);
    private long[] zzhje;
    private int size;

    zzdox() {
        this(new long[10], 0);
    }

    private zzdox(long[] lArray, int n) {
        this.zzhje = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzavk();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzhje, n2, this.zzhje, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzdox)) {
            return super.equals(object);
        }
        zzdox zzdox2 = (zzdox)object;
        if (this.size != zzdox2.size) {
            return false;
        }
        long[] lArray = zzdox2.zzhje;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzhje[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzdoc.zzft(this.zzhje[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzfj(n);
        return this.zzhje[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzfu(long l) {
        this.zzr(this.size, l);
    }

    private final void zzr(int n, long l) {
        this.zzavk();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
        if (this.size < this.zzhje.length) {
            System.arraycopy(this.zzhje, n, this.zzhje, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzhje, 0, lArray, 0, n);
            System.arraycopy(this.zzhje, n, lArray, n + 1, this.size - n);
            this.zzhje = lArray;
        }
        this.zzhje[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzavk();
        zzdoc.checkNotNull(collection);
        if (!(collection instanceof zzdox)) {
            return super.addAll(collection);
        }
        zzdox zzdox2 = (zzdox)collection;
        if (zzdox2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzdox2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzdox2.size;
        if (n > this.zzhje.length) {
            this.zzhje = Arrays.copyOf(this.zzhje, n);
        }
        System.arraycopy(zzdox2.zzhje, 0, this.zzhje, this.size, zzdox2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzavk();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzhje[i])) continue;
            System.arraycopy(this.zzhje, i + 1, this.zzhje, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzfj(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzfk(n));
        }
    }

    private final String zzfk(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzdox zzdox2 = this;
        zzdox2.zzavk();
        zzdox2.zzfj(n);
        long l3 = zzdox2.zzhje[n];
        zzdox2.zzhje[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzdox zzdox2 = this;
        zzdox2.zzavk();
        zzdox2.zzfj(n);
        long l = zzdox2.zzhje[n];
        if (n < zzdox2.size - 1) {
            System.arraycopy(zzdox2.zzhje, n + 1, zzdox2.zzhje, n, zzdox2.size - n - 1);
        }
        --zzdox2.size;
        ++zzdox2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzr(n, l);
    }

    @Override
    public final /* synthetic */ zzdoi zzfl(int n) {
        int n2 = n;
        zzdox zzdox2 = this;
        if (n2 < zzdox2.size) {
            throw new IllegalArgumentException();
        }
        return new zzdox(Arrays.copyOf(zzdox2.zzhje, n2), zzdox2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzhjd.zzavj();
    }
}

