/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzarw;
import com.google.android.gms.internal.ads.zzarx;
import com.google.android.gms.internal.ads.zzaxa;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@zzare
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="LargeParcelTeleporterCreator")
public final class zzarv
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzarv> CREATOR = new zzarx();
    @SafeParcelable.Field(id=2)
    private ParcelFileDescriptor zzdoq;
    private Parcelable zzdor;
    private boolean zzdos;

    @SafeParcelable.Constructor
    public zzarv(@SafeParcelable.Param(id=2) ParcelFileDescriptor parcelFileDescriptor) {
        this.zzdoq = parcelFileDescriptor;
        this.zzdor = null;
        this.zzdos = true;
    }

    public final <T extends SafeParcelable> T zza(Parcelable.Creator<T> creator) {
        if (this.zzdos) {
            byte[] byArray;
            if (this.zzdoq == null) {
                zzaxa.zzen((String)"File descriptor is empty, returning null.");
                return null;
            }
            DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzdoq));
            try {
                byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray, 0, byArray.length);
            }
            catch (IOException iOException) {
                zzaxa.zzc((String)"Could not read from parcel file descriptor", (Throwable)iOException);
                return null;
            }
            finally {
                IOUtils.closeQuietly((Closeable)dataInputStream);
            }
            Parcel parcel = Parcel.obtain();
            try {
                parcel.unmarshall(byArray, 0, byArray.length);
                parcel.setDataPosition(0);
                this.zzdor = (SafeParcelable)creator.createFromParcel(parcel);
            }
            finally {
                parcel.recycle();
            }
            this.zzdos = false;
        }
        return (T)((SafeParcelable)this.zzdor);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        this.zzts();
        Parcel parcel2 = parcel;
        zzarv zzarv2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzarv2.zzdoq, (int)n, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    private final ParcelFileDescriptor zzts() {
        if (this.zzdoq == null) {
            byte[] byArray;
            Parcel parcel = Parcel.obtain();
            try {
                this.zzdor.writeToParcel(parcel, 0);
                byArray = parcel.marshall();
            }
            finally {
                parcel.recycle();
            }
            this.zzdoq = this.zzi(byArray);
        }
        return this.zzdoq;
    }

    private final <T> ParcelFileDescriptor zzi(byte[] byArray) {
        ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream = null;
        try {
            ParcelFileDescriptor.AutoCloseOutputStream autoCloseOutputStream2;
            ParcelFileDescriptor[] parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
            ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
            autoCloseOutputStream = autoCloseOutputStream2 = new ParcelFileDescriptor.AutoCloseOutputStream(parcelFileDescriptor);
            zzarw zzarw2 = new zzarw(this, (OutputStream)autoCloseOutputStream2, byArray);
            new Thread(zzarw2).start();
            return parcelFileDescriptorArray[0];
        }
        catch (IOException iOException) {
            zzaxa.zzc((String)"Error transporting the ad response", (Throwable)iOException);
            zzk.zzlk().zza(iOException, "LargeParcelTeleporter.pipeData.2");
            IOUtils.closeQuietly(autoCloseOutputStream);
            return null;
        }
    }
}

