/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzawm;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxc;
import com.google.android.gms.internal.ads.zzaxe;
import com.google.android.gms.internal.ads.zzaxf;
import com.google.android.gms.internal.ads.zzaxh;
import com.google.android.gms.internal.ads.zzbbi;
import com.google.android.gms.internal.ads.zzus;
import com.google.android.gms.internal.ads.zzyr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzare
public final class zzaxd
implements zzaxc {
    private final Object lock = new Object();
    private boolean zzduy;
    private final List<Runnable> zzduz = new ArrayList<Runnable>();
    private zzbbi<?> zzdva;
    @Nullable
    @GuardedBy(value="lock")
    private zzus zzdvb = null;
    @Nullable
    @GuardedBy(value="lock")
    private SharedPreferences zzcko;
    @Nullable
    @GuardedBy(value="lock")
    private SharedPreferences.Editor zzdvc;
    @GuardedBy(value="lock")
    private boolean zzdvd = false;
    @GuardedBy(value="lock")
    private boolean zzdlu = true;
    @Nullable
    @GuardedBy(value="lock")
    private String zzdve;
    @Nullable
    @GuardedBy(value="lock")
    private String zzdvf;
    @GuardedBy(value="lock")
    private boolean zzdmj = false;
    @GuardedBy(value="lock")
    private String zzdmm = "";
    @GuardedBy(value="lock")
    private long zzdvg = 0L;
    @GuardedBy(value="lock")
    private long zzdvh = 0L;
    @GuardedBy(value="lock")
    private long zzdvi = 0L;
    @GuardedBy(value="lock")
    private int zzdvj = -1;
    @GuardedBy(value="lock")
    private int zzdvk = 0;
    @GuardedBy(value="lock")
    private Set<String> zzdvl = Collections.emptySet();
    @GuardedBy(value="lock")
    private JSONObject zzdvm = new JSONObject();
    @GuardedBy(value="lock")
    private boolean zzdnv = true;
    @GuardedBy(value="lock")
    private boolean zzdog = true;
    @GuardedBy(value="lock")
    private String zzdvn = null;

    public final void zza(Context context, String string2, boolean bl) {
        String string3;
        if (string2 == null) {
            string3 = "admob";
        } else {
            String string4 = String.valueOf("admob__");
            String string5 = String.valueOf(string2);
            string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        String string6 = string3;
        this.zzdva = zzaxh.zzc(new zzaxe(this, context, string6));
        this.zzduy = bl;
    }

    private final void zzvy() {
        if (this.zzdva == null) {
            return;
        }
        if (this.zzdva.isDone()) {
            return;
        }
        try {
            this.zzdva.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzaxa.zzd((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzaxa.zzc((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzvz() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.lock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzdlu);
            bundle.putBoolean("content_url_opted_out", this.zzdnv);
            bundle.putBoolean("content_vertical_opted_out", this.zzdog);
            bundle.putBoolean("auto_collect_location", this.zzdmj);
            bundle.putInt("version_code", this.zzdvk);
            bundle.putStringArray("never_pool_slots", this.zzdvl.toArray(new String[0]));
            bundle.putString("app_settings_json", this.zzdmm);
            bundle.putLong("app_settings_last_update_ms", this.zzdvg);
            bundle.putLong("app_last_background_time_ms", this.zzdvh);
            bundle.putInt("request_in_session_count", this.zzdvj);
            bundle.putLong("first_ad_req_time_ms", this.zzdvi);
            bundle.putString("native_advanced_settings", this.zzdvm.toString());
            bundle.putString("display_cutout", this.zzdvn);
            if (this.zzdve != null) {
                bundle.putString("content_url_hashes", this.zzdve);
            }
            if (this.zzdvf != null) {
                bundle.putString("content_vertical_hashes", this.zzdvf);
            }
        }
        return bundle;
    }

    private final void zzc(Bundle bundle) {
        zzaxh.zzdvr.execute(new zzaxf(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final zzus zzvk() {
        if (!this.zzduy) {
            return null;
        }
        if (!PlatformVersion.isAtLeastIceCreamSandwich()) {
            return null;
        }
        if (this.zzvl() && this.zzvn()) {
            return null;
        }
        zzaci zzaci2 = zzact.zzcnb;
        if (!((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (Looper.getMainLooper() == null) {
                return null;
            }
            if (this.zzdvb == null) {
                this.zzdvb = new zzus();
            }
            this.zzdvb.zzmv();
            zzaxa.zzeo((String)"start fetching content...");
            return this.zzdvb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzai(boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdnv == bl) {
                return;
            }
            this.zzdnv = bl;
            if (this.zzdvc != null) {
                this.zzdvc.putBoolean("content_url_opted_out", bl);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdnv);
            bundle.putBoolean("content_vertical_opted_out", this.zzdog);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzvl() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdnv;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdt(@Nullable String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdve)) {
                return;
            }
            this.zzdve = string2;
            if (this.zzdvc != null) {
                this.zzdvc.putString("content_url_hashes", string2);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzvm() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdve;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaj(boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdog == bl) {
                return;
            }
            this.zzdog = bl;
            if (this.zzdvc != null) {
                this.zzdvc.putBoolean("content_vertical_opted_out", bl);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdnv);
            bundle.putBoolean("content_vertical_opted_out", this.zzdog);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzvn() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdu(@Nullable String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdvf)) {
                return;
            }
            this.zzdvf = string2;
            if (this.zzdvc != null) {
                this.zzdvc.putString("content_vertical_hashes", string2);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzvo() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzak(boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdmj == bl) {
                return;
            }
            this.zzdmj = bl;
            if (this.zzdvc != null) {
                this.zzdvc.putBoolean("auto_collect_location", bl);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzvp() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdmj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzct(int n) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvk == n) {
                return;
            }
            this.zzdvk = n;
            if (this.zzdvc != null) {
                this.zzdvc.putInt("version_code", n);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzvq() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdv(String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            long l;
            this.zzdvg = l = zzk.zzln().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzdmm)) {
                return;
            }
            this.zzdmm = string2;
            if (this.zzdvc != null) {
                this.zzdvc.putString("app_settings_json", string2);
                this.zzdvc.putLong("app_settings_last_update_ms", l);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zzc(bundle);
            Iterator<Runnable> iterator = this.zzduz.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzawm zzvr() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return new zzawm(this.zzdmm, this.zzdvg);
        }
    }

    @Override
    public final void zzb(Runnable runnable) {
        this.zzduz.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfc(long l) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvh == l) {
                return;
            }
            this.zzdvh = l;
            if (this.zzdvc != null) {
                this.zzdvc.putLong("app_last_background_time_ms", l);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzvs() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvh;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcu(int n) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvj == n) {
                return;
            }
            this.zzdvj = n;
            if (this.zzdvc != null) {
                this.zzdvc.putInt("request_in_session_count", n);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzvt() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfd(long l) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvi == l) {
                return;
            }
            this.zzdvi = l;
            if (this.zzdvc != null) {
                this.zzdvc.putLong("first_ad_req_time_ms", l);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzvu() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzc(String string2, String string3, boolean bl) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzdvm.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false)) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzk.zzln().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzdvm.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzaxa.zzd((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzdvc != null) {
                this.zzdvc.putString("native_advanced_settings", this.zzdvm.toString());
                this.zzdvc.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzdvm.toString());
            this.zzc((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject zzvv() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzvw() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            this.zzdvm = new JSONObject();
            if (this.zzdvc != null) {
                this.zzdvc.remove("native_advanced_settings");
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String zzvx() {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdw(String string2) {
        this.zzvy();
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.equals((CharSequence)this.zzdvn, (CharSequence)string2)) {
                return;
            }
            this.zzdvn = string2;
            if (this.zzdvc != null) {
                this.zzdvc.putString("display_cutout", string2);
                this.zzdvc.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("display_cutout", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zzo(Context context, String string2) {
        String string3 = string2;
        Context context2 = context;
        zzaxd zzaxd2 = this;
        SharedPreferences sharedPreferences = context2.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Object object = zzaxd2.lock;
        synchronized (object) {
            zzaxd2.zzcko = sharedPreferences;
            zzaxd2.zzdvc = editor;
            zzaxd2.zzdvd = PlatformVersion.isAtLeastM() && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
            zzaxd2.zzdlu = zzaxd2.zzcko.getBoolean("use_https", zzaxd2.zzdlu);
            zzaxd2.zzdnv = zzaxd2.zzcko.getBoolean("content_url_opted_out", zzaxd2.zzdnv);
            zzaxd2.zzdve = zzaxd2.zzcko.getString("content_url_hashes", zzaxd2.zzdve);
            zzaxd2.zzdmj = zzaxd2.zzcko.getBoolean("auto_collect_location", zzaxd2.zzdmj);
            zzaxd2.zzdog = zzaxd2.zzcko.getBoolean("content_vertical_opted_out", zzaxd2.zzdog);
            zzaxd2.zzdvf = zzaxd2.zzcko.getString("content_vertical_hashes", zzaxd2.zzdvf);
            zzaxd2.zzdvk = zzaxd2.zzcko.getInt("version_code", zzaxd2.zzdvk);
            zzaxd2.zzdmm = zzaxd2.zzcko.getString("app_settings_json", zzaxd2.zzdmm);
            zzaxd2.zzdvg = zzaxd2.zzcko.getLong("app_settings_last_update_ms", zzaxd2.zzdvg);
            zzaxd2.zzdvh = zzaxd2.zzcko.getLong("app_last_background_time_ms", zzaxd2.zzdvh);
            zzaxd2.zzdvj = zzaxd2.zzcko.getInt("request_in_session_count", zzaxd2.zzdvj);
            zzaxd2.zzdvi = zzaxd2.zzcko.getLong("first_ad_req_time_ms", zzaxd2.zzdvi);
            zzaxd2.zzdvl = zzaxd2.zzcko.getStringSet("never_pool_slots", zzaxd2.zzdvl);
            zzaxd2.zzdvn = zzaxd2.zzcko.getString("display_cutout", zzaxd2.zzdvn);
            try {
                zzaxd2.zzdvm = new JSONObject(zzaxd2.zzcko.getString("native_advanced_settings", "{}"));
            }
            catch (JSONException jSONException) {
                zzaxa.zzd((String)"Could not convert native advanced settings to json object", (Throwable)jSONException);
            }
            zzaxd2.zzc(zzaxd2.zzvz());
            return;
        }
    }
}

