/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbez;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzry;
import com.google.android.gms.internal.ads.zzsj;
import com.google.android.gms.internal.ads.zzvq;
import com.google.android.gms.internal.ads.zzvt;
import com.google.android.gms.internal.ads.zzwg;
import com.google.android.gms.internal.ads.zzyr;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzare
public final class zzbey
implements zzrv {
    private InputStream zzege;
    private boolean isOpen;
    private final Context zzlj;
    private final zzrv zzegs;
    @Nullable
    private final zzsj<zzrv> zzegt;
    private final zzbez zzegu;
    private Uri uri;

    public zzbey(Context context, zzrv zzrv2, zzsj<zzrv> zzsj2, zzbez zzbez2) {
        this.zzlj = context;
        this.zzegs = zzrv2;
        this.zzegt = zzsj2;
        this.zzegu = zzbez2;
    }

    @Override
    public final void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to close an already closed CacheDataSource.");
        }
        this.isOpen = false;
        this.uri = null;
        if (this.zzege != null) {
            IOUtils.closeQuietly((Closeable)this.zzege);
            this.zzege = null;
        } else {
            this.zzegs.close();
        }
        zzbey zzbey2 = this;
        if (zzbey2.zzegt != null) {
            zzbey2.zzegt.zze(zzbey2);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final long zza(zzry zzry2) throws IOException {
        if (this.isOpen) {
            throw new IOException("Attempt to open an already open CacheDataSource.");
        }
        this.isOpen = true;
        this.uri = zzry2.uri;
        zzry zzry3 = zzry2;
        zzbey zzbey2 = this;
        if (zzbey2.zzegt != null) {
            zzbey2.zzegt.zza(zzbey2, zzry3);
        }
        zzvt zzvt2 = zzvt.zze(zzry2.uri);
        zzbey2 = zzact.zzctt;
        if (((Boolean)zzyr.zzpe().zzd((zzaci)zzbey2)).booleanValue()) {
            if (zzvt2 != null) {
                long l;
                Long l2;
                zzvt2.zzbwz = zzry2.zzahv;
                if (zzvt2.zzbwy) {
                    zzbey2 = zzact.zzctv;
                    l2 = (Long)zzyr.zzpe().zzd((zzaci)zzbey2);
                } else {
                    zzbey2 = zzact.zzctu;
                    l2 = (Long)zzyr.zzpe().zzd((zzaci)zzbey2);
                }
                long l3 = l2;
                long l4 = zzk.zzln().elapsedRealtime();
                zzk.zzma();
                Future<InputStream> future = zzwg.zza(this.zzlj, zzvt2);
                try {
                    this.zzege = future.get(l3, TimeUnit.MILLISECONDS);
                    l = zzk.zzln().elapsedRealtime() - l4;
                    this.zzegu.zzd(true, l);
                }
                catch (ExecutionException | TimeoutException exception) {
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    long l5 = zzk.zzln().elapsedRealtime() - l4;
                    this.zzegu.zzd(false, l5);
                    zzaxa.zzds(new StringBuilder(44).append("Cache connection took ").append(l5).append("ms").toString());
                }
                zzaxa.zzds(new StringBuilder(44).append("Cache connection took ").append(l).append("ms").toString());
                return -1L;
            }
        } else {
            zzvq zzvq2 = null;
            if (zzvt2 != null) {
                zzvt2.zzbwz = zzry2.zzahv;
                zzvq2 = zzk.zzlm().zza(zzvt2);
            }
            if (zzvq2 != null && zzvq2.zznh()) {
                this.zzege = zzvq2.zzni();
                return -1L;
            }
        }
        if (zzvt2 != null) {
            zzry2 = new zzry(Uri.parse((String)zzvt2.url), zzry2.zzbmd, zzry2.zzapg, zzry2.zzahv, zzry2.zzcd, zzry2.zzcc, zzry2.flags);
        }
        return this.zzegs.zza(zzry2);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to read closed CacheDataSource.");
        }
        int n3 = this.zzege != null ? this.zzege.read(byArray, n, n2) : this.zzegs.read(byArray, n, n2);
        int n4 = n3;
        zzbey zzbey2 = this;
        if (zzbey2.zzegt != null) {
            zzbey2.zzegt.zzc(zzbey2, n4);
        }
        return n3;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }
}

