/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.webkit.ValueCallback;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzbbn;
import com.google.android.gms.internal.ads.zzbiz;
import com.google.android.gms.internal.ads.zzbja;
import com.google.android.gms.internal.ads.zzbjb;
import com.google.android.gms.internal.ads.zzbjd;
import com.google.android.gms.internal.ads.zzbjf;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzare
@ParametersAreNonnullByDefault
public class zzbjc
extends zzbiz
implements zzbjf {
    private final zzbja zzemt;
    @GuardedBy(value="this")
    private boolean zzela;
    @GuardedBy(value="this")
    private boolean zzels;

    public zzbjc(Context context, zzbja zzbja2) {
        super(context);
        zzk.zzlk().zzuz();
        this.zzemt = zzbja2;
        super.setWebViewClient((WebViewClient)zzbja2);
    }

    public final synchronized boolean isDestroyed() {
        return this.zzela;
    }

    @GuardedBy(value="this")
    protected void zzaw(boolean bl) {
    }

    public synchronized void destroy() {
        if (this.zzela) {
            return;
        }
        this.zzela = true;
        this.zzemt.zza(this);
        this.zzaw(false);
        zzaxa.zzds("Initiating WebView self destruct sequence in 3...");
        zzaxa.zzds("Loading blank page in WebView, 2...");
        try {
            super.loadUrl("about:blank");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            zzk.zzlk().zza(unsatisfiedLinkError, "AdWebViewImpl.loadUrlUnsafe");
            zzaxa.zze((String)"#007 Could not call remote method.", (Throwable)unsatisfiedLinkError);
            return;
        }
    }

    @Override
    public final synchronized void zza(zzbjb zzbjb2) {
        zzaxa.zzds("Blank page loaded, 1...");
        this.zzaao();
    }

    @VisibleForTesting
    protected synchronized void zzaao() {
        zzaxa.zzds("Destroying WebView!");
        this.zzva();
        zzbbn.zzeag.execute(new zzbjd(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            zzbjc zzbjc2 = this;
            synchronized (zzbjc2) {
                if (!this.isDestroyed()) {
                    this.zzaw(true);
                }
                this.zzva();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private final synchronized void zzva() {
        if (!this.zzels) {
            this.zzels = true;
            zzk.zzlk().zzva();
        }
    }

    @TargetApi(value=19)
    public synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    @Override
    public synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            super.loadUrl(string2);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzaxa.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.isDestroyed() && super.onTouchEvent(motionEvent);
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        super.onPause();
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        super.onResume();
    }

    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        super.stopLoading();
    }

    public void setWebViewClient(WebViewClient webViewClient) {
    }

    final /* synthetic */ void zzacb() {
        super.destroy();
    }
}

