/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.internal.ads.zzaae;
import com.google.android.gms.internal.ads.zzaai;
import com.google.android.gms.internal.ads.zzaci;
import com.google.android.gms.internal.ads.zzact;
import com.google.android.gms.internal.ads.zzagc;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxj;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbap;
import com.google.android.gms.internal.ads.zzbmm;
import com.google.android.gms.internal.ads.zzbrh;
import com.google.android.gms.internal.ads.zzbrs;
import com.google.android.gms.internal.ads.zzbuz;
import com.google.android.gms.internal.ads.zzbxy;
import com.google.android.gms.internal.ads.zzbxz;
import com.google.android.gms.internal.ads.zzbys;
import com.google.android.gms.internal.ads.zzbza;
import com.google.android.gms.internal.ads.zzbzb;
import com.google.android.gms.internal.ads.zzbzp;
import com.google.android.gms.internal.ads.zzcci;
import com.google.android.gms.internal.ads.zzcxl;
import com.google.android.gms.internal.ads.zzcxu;
import com.google.android.gms.internal.ads.zzdad;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzyr;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzbxw
implements zzbza {
    private final Context zzlj;
    private final zzbzb zzfgy;
    private final JSONObject zzfmo;
    private final zzcci zzfmp;
    private final zzbys zzfmq;
    private final zzdh zzekq;
    private final zzbrs zzfmr;
    private final zzbrh zzfms;
    private final zzcxl zzfif;
    private final zzbaj zzbtd;
    private final zzcxu zzfjp;
    private final zzbmm zzfmt;
    private final zzbzp zzfmu;
    private final Clock zzbsb;
    private final zzbuz zzfmv;
    private final zzdad zzffd;
    private boolean zzfmw = false;
    private boolean zzfmx;
    private boolean zzfmy = false;
    private boolean zzfmz = false;
    private Point zzfna = new Point();
    private Point zzfnb = new Point();
    private long zzfnc = 0L;
    private long zzfnd = 0L;
    private zzaae zzfne;

    public zzbxw(Context context, zzbzb zzbzb2, JSONObject jSONObject, zzcci zzcci2, zzbys zzbys2, zzdh zzdh2, zzbrs zzbrs2, zzbrh zzbrh2, zzcxl zzcxl2, zzbaj zzbaj2, zzcxu zzcxu2, zzbmm zzbmm2, zzbzp zzbzp2, Clock clock, zzbuz zzbuz2, zzdad zzdad2) {
        this.zzlj = context;
        this.zzfgy = zzbzb2;
        this.zzfmo = jSONObject;
        this.zzfmp = zzcci2;
        this.zzfmq = zzbys2;
        this.zzekq = zzdh2;
        this.zzfmr = zzbrs2;
        this.zzfms = zzbrh2;
        this.zzfif = zzcxl2;
        this.zzbtd = zzbaj2;
        this.zzfjp = zzcxu2;
        this.zzfmt = zzbmm2;
        this.zzfmu = zzbzp2;
        this.zzbsb = clock;
        this.zzfmv = zzbuz2;
        this.zzffd = zzdad2;
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, View.OnTouchListener onTouchListener, View.OnClickListener onClickListener) {
        View view2;
        Iterator<Map.Entry<String, WeakReference<View>>> iterator;
        this.zzfna = new Point();
        this.zzfnb = new Point();
        if (!this.zzfmx) {
            this.zzfmv.zzq(view);
            this.zzfmx = true;
        }
        view.setOnTouchListener(onTouchListener);
        view.setClickable(true);
        view.setOnClickListener(onClickListener);
        this.zzfmt.zzq(this);
        if (map != null) {
            iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(onTouchListener);
                view2.setClickable(true);
                view2.setOnClickListener(onClickListener);
            }
        }
        if (map2 != null) {
            iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                view2 = (View)iterator.next().getValue().get();
                if (view2 == null) continue;
                view2.setOnTouchListener(onTouchListener);
                view2.setClickable(false);
            }
        }
    }

    @Override
    public final void zza(View view, @Nullable Map<String, WeakReference<View>> map) {
        this.zzfna = new Point();
        this.zzfnb = new Point();
        this.zzfmv.zzr(view);
        this.zzfmx = false;
    }

    private final boolean zzfh(String string2) {
        JSONObject jSONObject = this.zzfmo.optJSONObject("allow_pub_event_reporting");
        return jSONObject != null && jSONObject.optBoolean(string2, false);
    }

    @Override
    public final void zza(View view, @Nullable View view2, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        JSONObject jSONObject = this.zza(map, map2, view2);
        JSONObject jSONObject2 = this.zzs(view2);
        JSONObject jSONObject3 = zzbxw.zzt(view2);
        JSONObject jSONObject4 = this.zzu(view2);
        String string2 = this.zzb(view, map);
        JSONObject jSONObject5 = this.zzfj(string2);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, false);
    }

    @Nullable
    private final String zzb(@Nullable View view, @Nullable Map<String, WeakReference<View>> map) {
        if (map != null && view != null) {
            for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
                View view2 = (View)entry.getValue().get();
                if (!view.equals(view2)) continue;
                return entry.getKey();
            }
        }
        switch (this.zzfmq.zzahv()) {
            case 2: {
                return "2099";
            }
            case 1: {
                return "1099";
            }
            case 3: {
                return null;
            }
            case 6: {
                return "3099";
            }
        }
        return null;
    }

    @Override
    public final void zzfi(String string2) {
        this.zza(null, null, null, null, null, string2, null, null, false, false);
    }

    @Override
    public final void zzf(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzaxa.zzdp((String)"Click data is null. No click is reported.");
            return;
        }
        if (!this.zzfh("click_reporting")) {
            zzaxa.zzen((String)"The ad slot cannot handle external click events. You must be whitelisted to be able to report your click events.");
            return;
        }
        Bundle bundle2 = bundle.getBundle("click_signal");
        String string2 = bundle2 != null ? bundle2.getString("asset_id") : null;
        JSONObject jSONObject = zzk.zzlg().zza(bundle, null);
        this.zza(null, null, null, null, null, string2, null, jSONObject, false, false);
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, boolean bl) {
        if (!this.zzfmz) {
            zzaxa.zzdp((String)"Custom click reporting failed. enableCustomClickGesture is not set.");
            return;
        }
        if (!this.zzahj()) {
            zzaxa.zzdp((String)"Custom click reporting failed. Ad unit id not whitelisted.");
            return;
        }
        JSONObject jSONObject = this.zza(map, map2, view);
        JSONObject jSONObject2 = this.zzs(view);
        JSONObject jSONObject3 = zzbxw.zzt(view);
        JSONObject jSONObject4 = this.zzu(view);
        String string2 = this.zzb(null, map);
        JSONObject jSONObject5 = this.zzfj(string2);
        this.zza(view, jSONObject2, jSONObject, jSONObject3, jSONObject4, string2, jSONObject5, null, bl, true);
    }

    private final boolean zzahj() {
        return this.zzfmo.optBoolean("allow_custom_click_gesture", false);
    }

    @Override
    public final void zzro() {
        this.zzfmz = true;
    }

    private final void zza(@Nullable View view, @Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable String string2, @Nullable JSONObject jSONObject5, @Nullable JSONObject jSONObject6, boolean bl, boolean bl2) {
        Preconditions.checkMainThread((String)"performClick must be called on the main UI thread.");
        try {
            JSONObject jSONObject7 = new JSONObject();
            jSONObject7.put("ad", (Object)this.zzfmo);
            jSONObject7.put("asset_view_signal", (Object)jSONObject2);
            jSONObject7.put("ad_view_signal", (Object)jSONObject);
            jSONObject7.put("click_signal", (Object)jSONObject5);
            jSONObject7.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject7.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject7.put("has_custom_click_handler", this.zzfgy.zzfo(this.zzfmq.getCustomTemplateId()) != null);
            jSONObject7.put("provided_signals", (Object)jSONObject6);
            JSONObject jSONObject8 = new JSONObject();
            jSONObject8.put("asset_id", (Object)string2);
            jSONObject8.put("template", this.zzfmq.zzahv());
            jSONObject8.put("view_aware_api_used", bl);
            zzbxw zzbxw2 = this;
            jSONObject8.put("custom_mute_requested", zzbxw2.zzfjp.zzdgu != null && zzbxw2.zzfjp.zzdgu.zzbqh);
            zzbxw2 = this;
            jSONObject8.put("custom_mute_enabled", !zzbxw2.zzfmq.getMuteThisAdReasons().isEmpty() && zzbxw2.zzfmq.zzahx() != null);
            JSONObject jSONObject9 = jSONObject8;
            zzbxw2 = this;
            if (zzbxw2.zzfmu.zzaiz() != null && zzbxw2.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
                jSONObject9.put("custom_one_point_five_click_eligible", true);
            }
            jSONObject9.put("timestamp", zzbxw2.zzbsb.currentTimeMillis());
            boolean bl3 = bl2;
            jSONObject9 = jSONObject8;
            zzbxw2 = this;
            if (zzbxw2.zzfmz && zzbxw2.zzahj()) {
                jSONObject9.put("custom_click_gesture_eligible", true);
            }
            if (bl3) {
                jSONObject9.put("is_custom_click_gesture", true);
            }
            jSONObject8.put("has_custom_click_handler", this.zzfgy.zzfo(this.zzfmq.getCustomTemplateId()) != null);
            jSONObject8.put("click_signals", (Object)this.zzv(view));
            jSONObject7.put("click", (Object)jSONObject8);
            JSONObject jSONObject10 = new JSONObject();
            long l = this.zzbsb.currentTimeMillis();
            jSONObject10.put("time_from_last_touch_down", l - this.zzfnc);
            jSONObject10.put("time_from_last_touch", l - this.zzfnd);
            jSONObject7.put("touch_signal", (Object)jSONObject10);
            zzbap.zza(this.zzfmp.zzc("google.afma.nativeAds.handleClick", jSONObject7), "Error during performing handleClick");
            return;
        }
        catch (JSONException jSONException) {
            zzaxa.zzc((String)"Unable to create click JSON.", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final void zza(View view, MotionEvent motionEvent, @Nullable View view2) {
        long l;
        View view3 = view2;
        MotionEvent motionEvent2 = motionEvent;
        int[] nArray = zzbxw.zzw(view3);
        int n = (int)motionEvent2.getRawX() - nArray[0];
        int n2 = (int)motionEvent2.getRawY() - nArray[1];
        this.zzfna = new Point(n, n2);
        this.zzfnd = l = this.zzbsb.currentTimeMillis();
        if (motionEvent.getAction() == 0) {
            this.zzfnc = l;
            this.zzfnb = this.zzfna;
        }
        MotionEvent motionEvent3 = MotionEvent.obtain((MotionEvent)motionEvent);
        motionEvent3.setLocation((float)this.zzfna.x, (float)this.zzfna.y);
        this.zzekq.zza(motionEvent3);
        motionEvent3.recycle();
    }

    @Override
    public final void zzg(@Nullable Bundle bundle) {
        if (bundle == null) {
            zzaxa.zzdp((String)"Touch event data is null. No touch event is reported.");
            return;
        }
        if (!this.zzfh("touch_reporting")) {
            zzaxa.zzen((String)"The ad slot cannot handle external touch events. You must be whitelisted to be able to report your touch events.");
            return;
        }
        int n = (int)bundle.getFloat("x");
        int n2 = (int)bundle.getFloat("y");
        int n3 = bundle.getInt("duration_ms");
        this.zzekq.zzcg().zza(n, n2, n3);
    }

    @Override
    public final void zzahk() {
        this.zza((JSONObject)null, (JSONObject)null, (JSONObject)null, (JSONObject)null, (JSONObject)null);
    }

    @Override
    public final void setClickConfirmingView(View view) {
        if (!this.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzaxa.zzep((String)"setClickConfirmingView: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        View view2 = view;
        zzbzp zzbzp2 = this.zzfmu;
        if (view2 != null) {
            view2.setOnClickListener((View.OnClickListener)zzbzp2);
            view2.setClickable(true);
            zzbzp2.zzfqe = new WeakReference<View>(view2);
        }
    }

    @Override
    public final void zza(zzagc zzagc2) {
        if (!this.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
            zzaxa.zzep((String)"setUnconfirmedClickListener: Your account need to be whitelisted to use this feature.\nContact your account manager for more information.");
            return;
        }
        this.zzfmu.zza(zzagc2);
    }

    @Override
    public final void cancelUnconfirmedClick() {
        if (!this.zzfmo.optBoolean("custom_one_point_five_click_enabled", false)) {
            return;
        }
        this.zzfmu.cancelUnconfirmedClick();
    }

    @Override
    public final void zza(@Nullable zzaai zzaai2) {
        try {
            if (this.zzfmy) {
                return;
            }
            if (zzaai2 == null && this.zzfmq.zzahx() != null) {
                this.zzfmy = true;
                this.zzffd.zzed(this.zzfmq.zzahx().zzpt());
                this.zzahl();
                return;
            }
            this.zzfmy = true;
            this.zzffd.zzed(zzaai2.zzpt());
            this.zzahl();
            return;
        }
        catch (RemoteException remoteException) {
            zzaxa.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(zzaae zzaae2) {
        this.zzfne = zzaae2;
    }

    @Override
    public final void zzahl() {
        try {
            if (this.zzfne != null) {
                this.zzfne.onAdMuted();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzaxa.zze((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    @Override
    public final void zza(@Nullable View view, @Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2) {
        JSONObject jSONObject = this.zza(map, map2, view);
        JSONObject jSONObject2 = this.zzs(view);
        JSONObject jSONObject3 = zzbxw.zzt(view);
        JSONObject jSONObject4 = this.zzu(view);
        this.zza(jSONObject2, jSONObject, jSONObject3, jSONObject4, null);
    }

    @Override
    public final void zzahm() {
        Preconditions.checkMainThread((String)"recordDownloadedImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("ad", (Object)this.zzfmo);
            zzbap.zza(this.zzfmp.zzc("google.afma.nativeAds.handleDownloadedImpression", jSONObject), "Error during performing handleDownloadedImpression");
            return;
        }
        catch (JSONException jSONException) {
            zzbae.zzc((String)"", (Throwable)jSONException);
            return;
        }
    }

    @Override
    public final boolean zzh(Bundle bundle) {
        if (!this.zzfh("impression_reporting")) {
            zzaxa.zzen((String)"The ad slot cannot handle external impression events. You must be whitelisted to whitelisted to be able to report your impression events.");
            return false;
        }
        JSONObject jSONObject = zzk.zzlg().zza(bundle, null);
        return this.zza(null, null, null, null, jSONObject);
    }

    private final boolean zza(@Nullable JSONObject jSONObject, @Nullable JSONObject jSONObject2, @Nullable JSONObject jSONObject3, @Nullable JSONObject jSONObject4, @Nullable JSONObject jSONObject5) {
        Preconditions.checkMainThread((String)"recordImpression must be called on the main UI thread.");
        try {
            JSONObject jSONObject6 = new JSONObject();
            jSONObject6.put("ad", (Object)this.zzfmo);
            jSONObject6.put("asset_view_signal", (Object)jSONObject2);
            jSONObject6.put("ad_view_signal", (Object)jSONObject);
            jSONObject6.put("scroll_view_signal", (Object)jSONObject3);
            jSONObject6.put("lock_screen_signal", (Object)jSONObject4);
            jSONObject6.put("provided_signals", (Object)jSONObject5);
            this.zzfmp.zza("/logScionEvent", new zzbxy(this, null));
            this.zzfmp.zza("/nativeImpression", new zzbxz(this, null));
            zzbap.zza(this.zzfmp.zzc("google.afma.nativeAds.handleImpression", jSONObject6), "Error during performing handleImpression");
        }
        catch (JSONException jSONException) {
            zzaxa.zzc((String)"Unable to create impression JSON.", (Throwable)jSONException);
            return false;
        }
        if (!this.zzfmw && this.zzfif.zzgkj != null) {
            this.zzfmw |= zzk.zzlq().zzb(this.zzlj, this.zzbtd.zzbsy, this.zzfif.zzgkj.toString(), this.zzfjp.zzglb);
        }
        return true;
    }

    private final JSONObject zzb(Rect rect) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("width", this.zzdm(rect.right - rect.left));
        jSONObject.put("height", this.zzdm(rect.bottom - rect.top));
        jSONObject.put("x", this.zzdm(rect.left));
        jSONObject.put("y", this.zzdm(rect.top));
        jSONObject.put("relative_to", (Object)"self");
        return jSONObject;
    }

    private final JSONObject zzs(@Nullable View view) {
        JSONObject jSONObject;
        Object object;
        JSONObject jSONObject2 = new JSONObject();
        if (view == null) {
            return jSONObject2;
        }
        try {
            Object object2;
            object = zzbxw.zzw(view);
            jSONObject = new JSONObject();
            jSONObject.put("width", this.zzdm(view.getMeasuredWidth()));
            jSONObject.put("height", this.zzdm(view.getMeasuredHeight()));
            jSONObject.put("x", this.zzdm((int)object[0]));
            jSONObject.put("y", this.zzdm((int)object[1]));
            jSONObject.put("relative_to", (Object)"window");
            jSONObject2.put("frame", (Object)jSONObject);
            Rect rect = new Rect();
            if (view.getGlobalVisibleRect(rect)) {
                object2 = this.zzb(rect);
            } else {
                object2 = new JSONObject();
                object2.put("width", 0);
                object2.put("height", 0);
                object2.put("x", this.zzdm((int)object[0]));
                object2.put("y", this.zzdm((int)object[1]));
                object2.put("relative_to", (Object)"window");
            }
            jSONObject2.put("visible_bounds", object2);
        }
        catch (Exception exception) {
            zzaxa.zzep((String)"Unable to get native ad view bounding box");
        }
        zzaci zzaci2 = zzact.zzcww;
        if (((Boolean)zzyr.zzpe().zzd(zzaci2)).booleanValue()) {
            object = "";
            jSONObject = view.getParent();
            if (jSONObject != null) {
                try {
                    object = (String)jSONObject.getClass().getMethod("getTemplateTypeName", new Class[0]).invoke((Object)jSONObject, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (SecurityException securityException) {
                    zzaxa.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)securityException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    zzaxa.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    zzaxa.zzc((String)"Cannot access method getTemplateTypeName: ", (Throwable)invocationTargetException);
                }
            }
            try {
                switch (object) {
                    case "small_template": {
                        jSONObject2.put("native_template_type", 1);
                        break;
                    }
                    case "medium_template": {
                        jSONObject2.put("native_template_type", 2);
                        break;
                    }
                    default: {
                        jSONObject2.put("native_template_type", 0);
                        break;
                    }
                }
            }
            catch (JSONException jSONException) {
                zzaxa.zzc((String)"Could not log native template signal to JSON", (Throwable)jSONException);
            }
        }
        return jSONObject2;
    }

    private static JSONObject zzt(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzk.zzlg();
            int n = zzaxj.zzp(view);
            jSONObject.put("contained_in_scroll_view", n != -1);
        }
        catch (Exception exception) {}
        return jSONObject;
    }

    private final JSONObject zzu(@Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (view == null) {
            return jSONObject;
        }
        try {
            zzk.zzlg();
            jSONObject.put("can_show_on_lock_screen", zzaxj.zzo(view));
            zzk.zzlg();
            jSONObject.put("is_keyguard_locked", zzaxj.zzat(this.zzlj));
        }
        catch (JSONException jSONException) {
            zzaxa.zzep((String)"Unable to get lock screen information");
        }
        return jSONObject;
    }

    private final JSONObject zza(@Nullable Map<String, WeakReference<View>> map, @Nullable Map<String, WeakReference<View>> map2, @Nullable View view) {
        JSONObject jSONObject = new JSONObject();
        if (map == null || view == null) {
            return jSONObject;
        }
        int[] nArray = zzbxw.zzw(view);
        for (Map.Entry<String, WeakReference<View>> entry : map.entrySet()) {
            View view2 = (View)entry.getValue().get();
            if (view2 == null) continue;
            int[] nArray2 = zzbxw.zzw(view2);
            JSONObject jSONObject2 = new JSONObject();
            JSONObject jSONObject3 = new JSONObject();
            try {
                JSONObject jSONObject4;
                jSONObject3.put("width", this.zzdm(view2.getMeasuredWidth()));
                jSONObject3.put("height", this.zzdm(view2.getMeasuredHeight()));
                jSONObject3.put("x", this.zzdm(nArray2[0] - nArray[0]));
                jSONObject3.put("y", this.zzdm(nArray2[1] - nArray[1]));
                jSONObject3.put("relative_to", (Object)"ad_view");
                jSONObject2.put("frame", (Object)jSONObject3);
                Rect rect = new Rect();
                if (view2.getLocalVisibleRect(rect)) {
                    jSONObject4 = this.zzb(rect);
                } else {
                    jSONObject4 = new JSONObject();
                    jSONObject4.put("width", 0);
                    jSONObject4.put("height", 0);
                    jSONObject4.put("x", this.zzdm(nArray2[0] - nArray[0]));
                    jSONObject4.put("y", this.zzdm(nArray2[1] - nArray[1]));
                    jSONObject4.put("relative_to", (Object)"ad_view");
                }
                jSONObject2.put("visible_bounds", (Object)jSONObject4);
                if (view2 instanceof TextView) {
                    TextView textView = (TextView)view2;
                    jSONObject2.put("text_color", textView.getCurrentTextColor());
                    jSONObject2.put("font_size", (double)textView.getTextSize());
                    jSONObject2.put("text", (Object)textView.getText());
                }
                jSONObject2.put("is_clickable", map2 != null && map2.containsKey(entry.getKey()) && view2.isClickable());
                jSONObject.put(entry.getKey(), (Object)jSONObject2);
            }
            catch (JSONException jSONException) {
                zzaxa.zzep((String)"Unable to get asset views information");
            }
        }
        return jSONObject;
    }

    private final String zzv(View view) {
        try {
            JSONObject jSONObject = this.zzfmo.optJSONObject("tracking_urls_and_actions");
            if (jSONObject == null) {
                jSONObject = new JSONObject();
            }
            String string2 = jSONObject.optString("click_string");
            return this.zzekq.zzcg().zza(this.zzlj, string2, view);
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Exception obtaining click signals", (Throwable)exception);
            return null;
        }
    }

    private final JSONObject zzfj(@Nullable String string2) {
        JSONObject jSONObject = null;
        try {
            jSONObject = new JSONObject();
            jSONObject.put("click_point", (Object)this.zzahn());
            jSONObject.put("asset_id", (Object)string2);
        }
        catch (Exception exception) {
            zzaxa.zzc((String)"Error occurred while grabbing click signals.", (Throwable)exception);
        }
        return jSONObject;
    }

    @Nullable
    private final JSONObject zzahn() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("x", this.zzdm(this.zzfna.x));
            jSONObject.put("y", this.zzdm(this.zzfna.y));
            jSONObject.put("start_x", this.zzdm(this.zzfnb.x));
            jSONObject.put("start_y", this.zzdm(this.zzfnb.y));
            return jSONObject;
        }
        catch (JSONException jSONException) {
            zzaxa.zzc((String)"Error occurred while putting signals into JSON object.", (Throwable)jSONException);
            return null;
        }
    }

    private static int[] zzw(@Nullable View view) {
        int[] nArray = new int[2];
        if (view != null) {
            view.getLocationOnScreen(nArray);
        }
        return nArray;
    }

    private final int zzdm(int n) {
        return zzyr.zzpa().zzb(this.zzlj, n);
    }

    @Override
    public final void destroy() {
        this.zzfmp.destroy();
    }

    static /* synthetic */ zzbrs zza(zzbxw zzbxw2) {
        return zzbxw2.zzfmr;
    }

    static /* synthetic */ zzbrh zzb(zzbxw zzbxw2) {
        return zzbxw2.zzfms;
    }
}

