/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzdm;
import com.google.android.gms.internal.ads.zzdy;
import com.google.android.gms.internal.ads.zzef;
import com.google.android.gms.internal.ads.zzei;
import com.google.android.gms.internal.ads.zzej;
import java.lang.ref.WeakReference;

public final class zzeh
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zzyr = new Handler(Looper.getMainLooper());
    private final Context zzys;
    private Application zzww;
    @Nullable
    private final PowerManager zzyt;
    @Nullable
    private final KeyguardManager zzyu;
    private final zzdy zzvd;
    private BroadcastReceiver zzyv;
    private WeakReference<ViewTreeObserver> zzyw;
    private WeakReference<View> zzyx;
    private zzdm zzyy;
    private byte zzyz = (byte)-1;
    private int zzza = -1;
    private long zzzb = -3L;

    public zzeh(zzdy zzdy2, View view) {
        this.zzvd = zzdy2;
        this.zzys = zzdy2.zzlj;
        this.zzyt = (PowerManager)this.zzys.getSystemService("power");
        this.zzyu = (KeyguardManager)this.zzys.getSystemService("keyguard");
        if (this.zzys instanceof Application) {
            this.zzww = (Application)this.zzys;
            this.zzyy = new zzdm((Application)this.zzys, this);
        }
        this.zzd(view);
    }

    final void zzd(View view) {
        View view2 = this.zzyx != null ? (View)this.zzyx.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzf(view2);
        }
        this.zzyx = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zze(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzzb = -2L;
            return;
        }
        this.zzzb = -3L;
    }

    private final void zzcu() {
        zzyr.post((Runnable)new zzei(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzza = -1;
        this.zze(view);
        this.zzcw();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzza = -1;
        this.zzcw();
        this.zzcu();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzyx == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzyx.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzza = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzcw();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzcw();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzcw();
        this.zzcu();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzcw();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzcw();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzcw();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzcw();
    }

    public final void onGlobalLayout() {
        this.zzcw();
    }

    public final void onScrollChanged() {
        this.zzcw();
    }

    public final long zzcv() {
        if (this.zzzb <= -2L && this.zzyx.get() == null) {
            this.zzzb = -3L;
        }
        return this.zzzb;
    }

    private final void zzcw() {
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        byte by = 0;
        if (this.zzyx == null) {
            return;
        }
        View view2 = (View)this.zzyx.get();
        if (view2 == null) {
            this.zzzb = -3L;
            this.zzyz = (byte)-1;
            return;
        }
        if (view2.getVisibility() != 0) {
            by = 1;
        }
        if (!view2.isShown()) {
            by = (byte)(by | 2);
        }
        if (this.zzyt != null && !this.zzyt.isScreenOn()) {
            by = (byte)(by | 4);
        }
        if (!(this.zzvd.zzco() || this.zzyu != null && this.zzyu.inKeyguardRestrictedInputMode() && (activity = zzef.zzc(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0)) {
            by = (byte)(by | 8);
        }
        if (!view2.getGlobalVisibleRect(new Rect())) {
            by = (byte)(by | 0x10);
        }
        if (!view2.getLocalVisibleRect(new Rect())) {
            by = (byte)(by | 0x20);
        }
        int n = view2.getWindowVisibility();
        if ((this.zzza != -1 ? this.zzza : n) != 0) {
            by = (byte)(by | 0x40);
        }
        if (this.zzyz != by) {
            long l;
            this.zzyz = by;
            if (this.zzyz == 0) {
                l = SystemClock.elapsedRealtime();
            } else {
                zzeh zzeh2 = this;
                l = -3L - (long)zzeh2.zzyz;
            }
            this.zzzb = l;
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzyw = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzeh zzeh2 = this;
        if (zzeh2.zzyv == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzeh2.zzyv = new zzej(zzeh2);
            zzeh2.zzys.registerReceiver(zzeh2.zzyv, intentFilter);
        }
        if (this.zzww != null) {
            try {
                this.zzww.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzyy);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzyw != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzyw.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzyw = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzeh zzeh2 = this;
        if (zzeh2.zzyv != null) {
            try {
                zzeh2.zzys.unregisterReceiver(zzeh2.zzyv);
            }
            catch (Exception exception) {}
            zzeh2.zzyv = null;
        }
        if (this.zzww != null) {
            try {
                this.zzww.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzyy);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzeh zzeh2) {
        zzeh2.zzcw();
    }
}

