/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import com.google.android.gms.internal.ads.zzhj;
import com.google.android.gms.internal.ads.zzhk;
import com.google.android.gms.internal.ads.zzhm;
import com.google.android.gms.internal.ads.zzhn;
import com.google.android.gms.internal.ads.zzho;
import com.google.android.gms.internal.ads.zzhx;
import com.google.android.gms.internal.ads.zzkh;
import com.google.android.gms.internal.ads.zzkq;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.Map;

@Deprecated
@TargetApi(value=16)
public final class zzgl
implements zzhn {
    private final Context zzlj;
    private final Uri uri;
    private final Map<String, String> zzab;
    private final FileDescriptor zzacn;
    private final long zzaco;
    private final long zzacp;
    private MediaExtractor zzacq;
    private zzho[] zzacr;
    private boolean zzacs;
    private int zzact;
    private int[] zzacu;
    private boolean[] zzacv;
    private long zzacw;

    public zzgl(Context context, Uri uri, Map<String, String> map, int n) {
        zzkh.checkState(zzkq.SDK_INT >= 16);
        this.zzact = 2;
        this.zzlj = zzkh.checkNotNull(context);
        this.uri = zzkh.checkNotNull(uri);
        this.zzab = null;
        this.zzacn = null;
        this.zzaco = 0L;
        this.zzacp = 0L;
    }

    @Override
    public final boolean zzdg(long l) throws IOException {
        if (!this.zzacs) {
            this.zzacq = new MediaExtractor();
            if (this.zzlj != null) {
                this.zzacq.setDataSource(this.zzlj, this.uri, null);
            } else {
                this.zzacq.setDataSource(null, 0L, 0L);
            }
            this.zzacu = new int[this.zzacq.getTrackCount()];
            this.zzacv = new boolean[this.zzacu.length];
            this.zzacr = new zzho[this.zzacu.length];
            for (int i = 0; i < this.zzacu.length; ++i) {
                MediaFormat mediaFormat = this.zzacq.getTrackFormat(i);
                long l2 = mediaFormat.containsKey("durationUs") ? mediaFormat.getLong("durationUs") : -1L;
                String string2 = mediaFormat.getString("mime");
                this.zzacr[i] = new zzho(string2, l2);
            }
            this.zzacs = true;
        }
        return true;
    }

    @Override
    public final int getTrackCount() {
        zzkh.checkState(this.zzacs);
        return this.zzacu.length;
    }

    @Override
    public final zzho zzo(int n) {
        zzkh.checkState(this.zzacs);
        return this.zzacr[n];
    }

    @Override
    public final void zza(int n, long l) {
        zzkh.checkState(this.zzacs);
        zzkh.checkState(this.zzacu[n] == 0);
        this.zzacu[n] = 1;
        this.zzacq.selectTrack(n);
        this.zza(l, l != 0L);
    }

    @Override
    public final boolean zzdh(long l) {
        return true;
    }

    @Override
    public final int zza(int n, long l, zzhk zzhk2, zzhm zzhm2, boolean bl) {
        zzkh.checkState(this.zzacs);
        zzkh.checkState(this.zzacu[n] != 0);
        if (this.zzacv[n]) {
            this.zzacv[n] = false;
            return -5;
        }
        if (bl) {
            return -2;
        }
        if (this.zzacu[n] != 2) {
            zzhx zzhx2;
            zzhk2.zzado = zzhj.zza(this.zzacq.getTrackFormat(n));
            if (zzkq.SDK_INT >= 18) {
                Map map = this.zzacq.getPsshInfo();
                if (map == null || map.isEmpty()) {
                    zzhx2 = null;
                } else {
                    zzhx zzhx3 = new zzhx("video/mp4");
                    zzhx3.putAll(map);
                    zzhx2 = zzhx3;
                }
            } else {
                zzhx2 = null;
            }
            zzhk2.zzadp = zzhx2;
            this.zzacu[n] = 2;
            return -4;
        }
        int n2 = this.zzacq.getSampleTrackIndex();
        if (n2 == n) {
            if (zzhm2.zzde != null) {
                int n3 = zzhm2.zzde.position();
                zzhm2.size = this.zzacq.readSampleData(zzhm2.zzde, n3);
                zzhm2.zzde.position(n3 + zzhm2.size);
            } else {
                zzhm2.size = 0;
            }
            zzhm2.zzaga = this.zzacq.getSampleTime();
            zzhm2.flags = this.zzacq.getSampleFlags() & 3;
            if (zzhm2.zzeo()) {
                zzhm2.zzafz.zza(this.zzacq);
            }
            this.zzacw = -1L;
            this.zzacq.advance();
            return -3;
        }
        if (n2 < 0) {
            return -1;
        }
        return -2;
    }

    @Override
    public final void zzp(int n) {
        zzkh.checkState(this.zzacs);
        zzkh.checkState(this.zzacu[n] != 0);
        this.zzacq.unselectTrack(n);
        this.zzacv[n] = false;
        this.zzacu[n] = 0;
    }

    @Override
    public final void zzdi(long l) {
        zzkh.checkState(this.zzacs);
        this.zza(l, false);
    }

    @Override
    public final long zzdu() {
        zzkh.checkState(this.zzacs);
        long l = this.zzacq.getCachedDuration();
        if (l == -1L) {
            return -1L;
        }
        long l2 = this.zzacq.getSampleTime();
        if (l2 == -1L) {
            return -3L;
        }
        return l2 + l;
    }

    @Override
    public final void release() {
        zzkh.checkState(this.zzact > 0);
        if (--this.zzact == 0 && this.zzacq != null) {
            this.zzacq.release();
            this.zzacq = null;
        }
    }

    private final void zza(long l, boolean bl) {
        if (bl || this.zzacw != l) {
            this.zzacw = l;
            this.zzacq.seekTo(l, 0);
            for (int i = 0; i < this.zzacu.length; ++i) {
                if (this.zzacu[i] == 0) continue;
                this.zzacv[i] = true;
            }
        }
    }
}

