/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzgt;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzej
extends zzdj<Double>
implements zzfg<Double>,
zzgt,
RandomAccess {
    private static final zzej zzadg = new zzej(new double[0], 0);
    private double[] zzadh;
    private int size;

    zzej() {
        this(new double[10], 0);
    }

    private zzej(double[] dArray, int n) {
        this.zzadh = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzka();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzadh, n2, this.zzadh, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzej)) {
            return super.equals(object);
        }
        zzej zzej2 = (zzej)object;
        if (this.size != zzej2.size) {
            return false;
        }
        double[] dArray = zzej2.zzadh;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzadh[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzadh[i]);
            n = n * 31 + zzfb.zzba(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzf(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzka();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
        if (this.size < this.zzadh.length) {
            System.arraycopy(this.zzadh, n, this.zzadh, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzadh, 0, dArray, 0, n);
            System.arraycopy(this.zzadh, n, dArray, n + 1, this.size - n);
            this.zzadh = dArray;
        }
        this.zzadh[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzka();
        zzfb.checkNotNull(collection);
        if (!(collection instanceof zzej)) {
            return super.addAll(collection);
        }
        zzej zzej2 = (zzej)collection;
        if (zzej2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzej2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzej2.size;
        if (n > this.zzadh.length) {
            this.zzadh = Arrays.copyOf(this.zzadh, n);
        }
        System.arraycopy(zzej2.zzadh, 0, this.zzadh, this.size, zzej2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzka();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzadh[i])) continue;
            System.arraycopy(this.zzadh, i + 1, this.zzadh, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzo(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzp(n));
        }
    }

    private final String zzp(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzej zzej2 = this;
        zzej2.zzka();
        zzej2.zzo(n);
        double d3 = zzej2.zzadh[n];
        zzej2.zzadh[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzej zzej2 = this;
        zzej2.zzka();
        zzej2.zzo(n);
        double d = zzej2.zzadh[n];
        if (n < zzej2.size - 1) {
            System.arraycopy(zzej2.zzadh, n + 1, zzej2.zzadh, n, zzej2.size - n - 1);
        }
        --zzej2.size;
        ++zzej2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzfg zzq(int n) {
        int n2 = n;
        zzej zzej2 = this;
        if (n2 < zzej2.size) {
            throw new IllegalArgumentException();
        }
        return new zzej(Arrays.copyOf(zzej2.zzadh, n2), zzej2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzej zzej2 = this;
        zzej2.zzo(n);
        return zzej2.zzadh[n];
    }

    static {
        zzadg.zzjz();
    }
}

