/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzby;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzm;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzt;

public final class zzap
extends zzf {
    private String zzcf;
    private String zzcn;
    private int zzjg;
    private String zzcp;
    private String zzjh;
    private long zzji;
    private long zzcs;
    private long zzu;
    private int zzdq;
    private String zzch;
    private String zzcv;

    zzap(zzby zzby2, long l) {
        super(zzby2);
        this.zzu = l;
    }

    @Override
    protected final boolean zzak() {
        return true;
    }

    @Override
    protected final void zzal() {
        Object object;
        PackageInfo packageInfo;
        String string = "unknown";
        String string2 = "Unknown";
        int n = Integer.MIN_VALUE;
        String string3 = "Unknown";
        String string4 = ((zzct)this).getContext().getPackageName();
        PackageManager packageManager = ((zzct)this).getContext().getPackageManager();
        if (packageManager == null) {
            ((zzct)this).zzad().zzda().zza("PackageManager is null, app identity information might be inaccurate. appId", zzau.zzao(string4));
        } else {
            try {
                string = packageManager.getInstallerPackageName(string4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ((zzct)this).zzad().zzda().zza("Error retrieving app installer package name. appId", zzau.zzao(string4));
            }
            if (string == null) {
                string = "manual_install";
            } else if ("com.android.vending".equals(string)) {
                string = "";
            }
            try {
                packageInfo = packageManager.getPackageInfo(((zzct)this).getContext().getPackageName(), 0);
                if (packageInfo != null) {
                    CharSequence charSequence = packageManager.getApplicationLabel(packageInfo.applicationInfo);
                    if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                        string3 = charSequence.toString();
                    }
                    string2 = packageInfo.versionName;
                    n = packageInfo.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                ((zzct)this).zzad().zzda().zza("Error retrieving package info. appId, appName", zzau.zzao(string4), string3);
            }
        }
        this.zzcf = string4;
        this.zzcp = string;
        this.zzcn = string2;
        this.zzjg = n;
        this.zzjh = string3;
        this.zzji = 0L;
        zzq zzq2 = ((zzct)this).zzag();
        packageInfo = GoogleServices.initialize((Context)((zzct)this).getContext());
        boolean bl = (packageInfo != null && packageInfo.isSuccess()) | (!TextUtils.isEmpty((CharSequence)this.zzl.zzem()) && "am".equals(this.zzl.zzen()));
        if (!bl) {
            PackageInfo packageInfo2 = packageInfo;
            zzap zzap2 = this;
            if (packageInfo2 == null) {
                ((zzct)zzap2).zzad().zzda().zzaq("GoogleService failed to initialize (no status)");
            } else {
                ((zzct)zzap2).zzad().zzda().zza("GoogleService failed to initialize, status", packageInfo2.getStatusCode(), packageInfo2.getStatusMessage());
            }
        }
        boolean bl2 = false;
        if (bl) {
            object = ((zzct)this).zzaf().zzbr();
            if (((zzct)this).zzaf().zzbq()) {
                if (this.zzl.zzel()) {
                    ((zzct)this).zzad().zzdg().zzaq("Collection disabled with firebase_analytics_collection_deactivated=1");
                }
            } else if (object != null && !((Boolean)object).booleanValue()) {
                if (this.zzl.zzel()) {
                    ((zzct)this).zzad().zzdg().zzaq("Collection disabled with firebase_analytics_collection_enabled=0");
                }
            } else if (object == null && GoogleServices.isMeasurementExplicitlyDisabled()) {
                ((zzct)this).zzad().zzdg().zzaq("Collection disabled with google_app_measurement_enable=0");
            } else {
                bl2 = true;
                ((zzct)this).zzad().zzdi().zzaq("Collection enabled");
            }
        }
        this.zzch = "";
        this.zzcv = "";
        this.zzcs = 0L;
        zzq2 = ((zzct)this).zzag();
        if (!TextUtils.isEmpty((CharSequence)this.zzl.zzem()) && "am".equals(this.zzl.zzen())) {
            this.zzcv = this.zzl.zzem();
        }
        try {
            object = GoogleServices.getGoogleAppId();
            Object object2 = this.zzch = TextUtils.isEmpty((CharSequence)object) ? "" : object;
            if (!TextUtils.isEmpty((CharSequence)object)) {
                StringResourceValueReader stringResourceValueReader = new StringResourceValueReader(((zzct)this).getContext());
                this.zzcv = stringResourceValueReader.getString("admob_app_id");
            }
            if (bl2) {
                ((zzct)this).zzad().zzdi().zza("App package, google app id", this.zzcf, this.zzch);
            }
        }
        catch (IllegalStateException illegalStateException) {
            ((zzct)this).zzad().zzda().zza("getGoogleAppId or isMeasurementEnabled failed with exception. appId", zzau.zzao(string4), illegalStateException);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.zzdq = InstantApps.isInstantApp((Context)((zzct)this).getContext()) ? 1 : 0;
            return;
        }
        this.zzdq = 0;
    }

    @WorkerThread
    final zzm zzak(String string) {
        ((zzct)this).zzq();
        ((zzct)this).zzo();
        String string2 = this.zzan();
        String string3 = this.getGmpAppId();
        zzct zzct2 = this;
        ((zzf)zzct2).zzah();
        String string4 = ((zzap)zzct2).zzcn;
        long l = this.zzcx();
        zzct2 = this;
        ((zzf)zzct2).zzah();
        String string5 = ((zzap)zzct2).zzcp;
        long l2 = ((zzct)this).zzaf().zzav();
        zzct2 = this;
        ((zzf)zzct2).zzah();
        zzct2.zzq();
        if (((zzap)zzct2).zzji == 0L) {
            ((zzap)zzct2).zzji = ((zzap)zzct2).zzl.zzab().zzc(zzct2.getContext(), zzct2.getContext().getPackageName());
        }
        long l3 = ((zzap)zzct2).zzji;
        boolean bl = this.zzl.isEnabled();
        boolean bl2 = !((zzct)this).zzae().zzlu;
        zzct2 = this;
        zzct2.zzq();
        zzct2.zzo();
        String string6 = zzct2.zzaf().zzr(((zzap)zzct2).zzcf) && !((zzap)zzct2).zzl.isEnabled() ? null : ((zzap)zzct2).zzcw();
        zzct2 = this;
        ((zzf)zzct2).zzah();
        long l4 = ((zzap)zzct2).zzcs;
        long l5 = this.zzl.zzer();
        int n = this.zzcy();
        zzct2 = ((zzct)this).zzaf();
        zzct2.zzo();
        Boolean bl3 = ((zzt)zzct2).zzj("google_analytics_adid_collection_enabled");
        boolean bl4 = bl3 == null || bl3 != false;
        zzct2 = ((zzct)this).zzaf();
        zzct2.zzo();
        bl3 = ((zzt)zzct2).zzj("google_analytics_ssaid_collection_enabled");
        return new zzm(string2, string3, string4, l, string5, l2, l3, string, bl, bl2, string6, l4, l5, n, bl4, bl3 == null || bl3 != false, ((zzct)this).zzae().zzdy(), this.zzao(), ((zzct)this).zzaf().zze(this.zzan(), zzal.zzin) && (bl3 = ((zzct)this).zzaf().zzj("google_analytics_default_allow_ad_personalization_signals")) != null ? Boolean.valueOf(bl3 == false) : null, this.zzu);
    }

    @WorkerThread
    @VisibleForTesting
    private final String zzcw() {
        Object object;
        Class<?> clazz;
        try {
            clazz = ((zzct)this).getContext().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
            if (clazz == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            object = clazz.getDeclaredMethod("getInstance", Context.class).invoke(null, ((zzct)this).getContext());
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            ((zzct)this).zzad().zzde().zzaq("Failed to obtain Firebase Analytics instance");
            return null;
        }
        try {
            return (String)clazz.getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            ((zzct)this).zzad().zzdf().zzaq("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    final String zzan() {
        this.zzah();
        return this.zzcf;
    }

    final String getGmpAppId() {
        this.zzah();
        return this.zzch;
    }

    final String zzao() {
        this.zzah();
        return this.zzcv;
    }

    final int zzcx() {
        this.zzah();
        return this.zzjg;
    }

    final int zzcy() {
        this.zzah();
        return this.zzdq;
    }
}

