/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.support.annotation.MainThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzct;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzez;
import com.google.android.gms.measurement.internal.zzfa;
import com.google.android.gms.measurement.internal.zzfb;
import com.google.android.gms.measurement.internal.zzfc;
import com.google.android.gms.measurement.internal.zzfd;

@VisibleForTesting
public final class zzey
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzqw;
    private volatile zzat zzqx;
    final /* synthetic */ zzeg zzqq;

    protected zzey(zzeg zzeg2) {
        this.zzqq = zzeg2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb(Intent intent) {
        ((zzct)this.zzqq).zzq();
        Context context = ((zzct)this.zzqq).getContext();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzey zzey2 = this;
        synchronized (zzey2) {
            if (this.zzqw) {
                ((zzct)this.zzqq).zzad().zzdi().zzaq("Connection attempt already in progress");
                return;
            }
            ((zzct)this.zzqq).zzad().zzdi().zzaq("Using local app measurement service");
            this.zzqw = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzeg.zza(this.zzqq), 129);
            return;
        }
    }

    @WorkerThread
    public final void zzfl() {
        if (this.zzqx != null && (this.zzqx.isConnected() || this.zzqx.isConnecting())) {
            this.zzqx.disconnect();
        }
        this.zzqx = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzey zzey2 = this;
        synchronized (zzey2) {
            String string;
            if (iBinder == null) {
                this.zzqw = false;
                ((zzct)this.zzqq).zzad().zzda().zzaq("Service connected with null binder");
                return;
            }
            zzam zzam2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzam2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzam ? (zzam)iInterface : new zzao(iBinder2));
                    ((zzct)this.zzqq).zzad().zzdi().zzaq("Bound to IMeasurementService interface");
                } else {
                    ((zzct)this.zzqq).zzad().zzda().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzct)this.zzqq).zzad().zzda().zzaq("Service connect failed to get IMeasurementService");
            }
            if (zzam2 == null) {
                this.zzqw = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzct)this.zzqq).getContext(), (ServiceConnection)zzeg.zza(this.zzqq));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzam2;
                ((zzct)this.zzqq).zzac().zza(new zzez(this, (zzam)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzct)this.zzqq).zzad().zzdh().zzaq("Service disconnected");
        ((zzct)this.zzqq).zzac().zza(new zzfa(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzfm() {
        ((zzct)this.zzqq).zzq();
        Context context = ((zzct)this.zzqq).getContext();
        zzey zzey2 = this;
        synchronized (zzey2) {
            if (this.zzqw) {
                ((zzct)this.zzqq).zzad().zzdi().zzaq("Connection attempt already in progress");
                return;
            }
            if (this.zzqx != null && (this.zzqx.isConnecting() || this.zzqx.isConnected())) {
                ((zzct)this.zzqq).zzad().zzdi().zzaq("Already awaiting connection attempt");
                return;
            }
            this.zzqx = new zzat(context, Looper.getMainLooper(), this, this);
            ((zzct)this.zzqq).zzad().zzdi().zzaq("Connecting to remote service");
            this.zzqw = true;
            this.zzqx.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzey zzey2 = this;
        synchronized (zzey2) {
            try {
                zzam zzam2 = (zzam)this.zzqx.getService();
                ((zzct)this.zzqq).zzac().zza(new zzfb(this, zzam2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzqx = null;
                this.zzqw = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzct)this.zzqq).zzad().zzdh().zzaq("Service connection suspended");
        ((zzct)this.zzqq).zzac().zza(new zzfc(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzau zzau2 = this.zzqq.zzl.zzei();
        if (zzau2 != null) {
            zzau2.zzdd().zza("Service connection failed", connectionResult);
        }
        zzey zzey2 = this;
        synchronized (zzey2) {
            this.zzqw = false;
            this.zzqx = null;
        }
        ((zzct)this.zzqq).zzac().zza(new zzfd(this));
    }

    static /* synthetic */ boolean zza(zzey zzey2, boolean bl) {
        zzey2.zzqw = false;
        return false;
    }
}

