/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads;

import android.content.Context;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresPermission;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.doubleclick.PublisherAdRequest;
import com.google.android.gms.ads.formats.NativeAdOptions;
import com.google.android.gms.ads.formats.NativeAppInstallAd;
import com.google.android.gms.ads.formats.NativeContentAd;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.formats.OnPublisherAdViewLoadedListener;
import com.google.android.gms.ads.formats.PublisherAdViewOptions;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzaax;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzagl;
import com.google.android.gms.internal.ads.zzagm;
import com.google.android.gms.internal.ads.zzagn;
import com.google.android.gms.internal.ads.zzago;
import com.google.android.gms.internal.ads.zzagp;
import com.google.android.gms.internal.ads.zzagr;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzya;
import com.google.android.gms.internal.ads.zzyb;
import com.google.android.gms.internal.ads.zzyr;
import com.google.android.gms.internal.ads.zzza;
import com.google.android.gms.internal.ads.zzzd;

public class AdLoader {
    private final zzya zzaaj;
    private final Context zzlj;
    private final zzza zzaak;

    AdLoader(Context context, zzza zzza2) {
        this(context, zzza2, zzya.zzchf);
    }

    private AdLoader(Context context, zzza zzza2, zzya zzya2) {
        this.zzlj = context;
        this.zzaak = zzza2;
        this.zzaaj = zzya2;
    }

    private final void zza(zzaax zzaax2) {
        try {
            this.zzaak.zza(zzya.zza(this.zzlj, zzaax2));
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Failed to load ad.", remoteException);
            return;
        }
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAd(AdRequest adRequest) {
        this.zza(adRequest.zzde());
    }

    @RequiresPermission(value="android.permission.INTERNET")
    public void loadAds(AdRequest adRequest, int n) {
        zzaax zzaax2 = adRequest.zzde();
        AdLoader adLoader = this;
        try {
            adLoader.zzaak.zza(zzya.zza(adLoader.zzlj, zzaax2), n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Failed to load ads.", remoteException);
            return;
        }
    }

    public void loadAd(PublisherAdRequest publisherAdRequest) {
        this.zza(publisherAdRequest.zzde());
    }

    @Deprecated
    public String getMediationAdapterClassName() {
        try {
            return this.zzaak.zzpj();
        }
        catch (RemoteException remoteException) {
            zzbae.zzd("Failed to get the mediation adapter class name.", remoteException);
            return null;
        }
    }

    public boolean isLoading() {
        try {
            return this.zzaak.isLoading();
        }
        catch (RemoteException remoteException) {
            zzbae.zzd("Failed to check if ad is loading.", remoteException);
            return false;
        }
    }

    public static class Builder {
        private final Context zzlj;
        private final zzzd zzaal;

        public Builder(Context context, String string) {
            this((Context)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null"), zzyr.zzpb().zzb(context, string, new zzamp()));
        }

        private Builder(Context context, zzzd zzzd2) {
            this.zzlj = context;
            this.zzaal = zzzd2;
        }

        @Deprecated
        public Builder forContentAd(NativeContentAd.OnContentAdLoadedListener onContentAdLoadedListener) {
            try {
                this.zzaal.zza(new zzagm(onContentAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to add content ad listener", remoteException);
            }
            return this;
        }

        @Deprecated
        public Builder forAppInstallAd(NativeAppInstallAd.OnAppInstallAdLoadedListener onAppInstallAdLoadedListener) {
            try {
                this.zzaal.zza(new zzagl(onAppInstallAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to add app install ad listener", remoteException);
            }
            return this;
        }

        public Builder forUnifiedNativeAd(UnifiedNativeAd.OnUnifiedNativeAdLoadedListener onUnifiedNativeAdLoadedListener) {
            try {
                this.zzaal.zza(new zzagr(onUnifiedNativeAdLoadedListener));
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to add google native ad listener", remoteException);
            }
            return this;
        }

        public Builder forCustomTemplateAd(String string, NativeCustomTemplateAd.OnCustomTemplateAdLoadedListener onCustomTemplateAdLoadedListener, NativeCustomTemplateAd.OnCustomClickListener onCustomClickListener) {
            try {
                this.zzaal.zza(string, new zzago(onCustomTemplateAdLoadedListener), onCustomClickListener == null ? null : new zzagn(onCustomClickListener));
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to add custom template ad listener", remoteException);
            }
            return this;
        }

        public Builder forPublisherAdView(OnPublisherAdViewLoadedListener onPublisherAdViewLoadedListener, AdSize ... adSizeArray) {
            if (adSizeArray == null || adSizeArray.length <= 0) {
                throw new IllegalArgumentException("The supported ad sizes must contain at least one valid ad size.");
            }
            try {
                zzyb zzyb2 = new zzyb(this.zzlj, adSizeArray);
                this.zzaal.zza(new zzagp(onPublisherAdViewLoadedListener), zzyb2);
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to add publisher banner ad listener", remoteException);
            }
            return this;
        }

        public Builder withAdListener(AdListener adListener) {
            try {
                this.zzaal.zza(new zzxt(adListener));
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to set AdListener.", remoteException);
            }
            return this;
        }

        public Builder withNativeAdOptions(NativeAdOptions nativeAdOptions) {
            try {
                this.zzaal.zza(new zzadx(nativeAdOptions));
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to specify native ad options", remoteException);
            }
            return this;
        }

        public Builder withPublisherAdViewOptions(PublisherAdViewOptions publisherAdViewOptions) {
            try {
                this.zzaal.zza(publisherAdViewOptions);
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to specify DFP banner ad options", remoteException);
            }
            return this;
        }

        public Builder withCorrelator(@NonNull Correlator correlator) {
            Preconditions.checkNotNull((Object)correlator);
            try {
                this.zzaal.zza(correlator.zzaar);
            }
            catch (RemoteException remoteException) {
                zzbae.zzd("Failed to set correlator.", remoteException);
            }
            return this;
        }

        public AdLoader build() {
            try {
                return new AdLoader(this.zzlj, this.zzaal.zzpk());
            }
            catch (RemoteException remoteException) {
                zzbae.zzc("Failed to build AdLoader.", remoteException);
                return null;
            }
        }
    }
}

