/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.formats;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.google.android.gms.ads.formats.AdChoicesView;
import com.google.android.gms.ads.formats.MediaView;
import com.google.android.gms.ads.formats.UnifiedNativeAd;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzael;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzyr;

public final class UnifiedNativeAdView
extends FrameLayout {
    private final FrameLayout zzbqi;
    private final zzael zzbqj;

    public UnifiedNativeAdView(Context context) {
        super(context);
        this.zzbqi = this.zzd(context);
        this.zzbqj = this.zzks();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.zzbqi = this.zzd(context);
        this.zzbqj = this.zzks();
    }

    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.zzbqi = this.zzd(context);
        this.zzbqj = this.zzks();
    }

    @TargetApi(value=21)
    public UnifiedNativeAdView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.zzbqi = this.zzd(context);
        this.zzbqj = this.zzks();
    }

    private final void zza(String string, View view) {
        try {
            this.zzbqj.zzc(string, ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to call setAssetView on delegate", remoteException);
            return;
        }
    }

    public final void setHeadlineView(View view) {
        this.zza("3001", view);
    }

    public final void setCallToActionView(View view) {
        this.zza("3002", view);
    }

    public final void setIconView(View view) {
        this.zza("3003", view);
    }

    public final void setBodyView(View view) {
        this.zza("3004", view);
    }

    public final void setAdvertiserView(View view) {
        this.zza("3005", view);
    }

    public final void setStoreView(View view) {
        this.zza("3006", view);
    }

    public final void setClickConfirmingView(View view) {
        try {
            this.zzbqj.zzi(ObjectWrapper.wrap((Object)view));
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to call setClickConfirmingView on delegate", remoteException);
            return;
        }
    }

    public final void setPriceView(View view) {
        this.zza("3007", view);
    }

    public final void setImageView(View view) {
        this.zza("3008", view);
    }

    public final void setStarRatingView(View view) {
        this.zza("3009", view);
    }

    public final void setMediaView(MediaView mediaView) {
        this.zza("3010", (View)mediaView);
    }

    public final void setAdChoicesView(AdChoicesView adChoicesView) {
        this.zza("3011", (View)adChoicesView);
    }

    public final void setNativeAd(UnifiedNativeAd unifiedNativeAd) {
        try {
            this.zzbqj.zze((IObjectWrapper)unifiedNativeAd.zzkq());
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to call setNativeAd on delegate", remoteException);
            return;
        }
    }

    private final View zzbj(String string) {
        try {
            IObjectWrapper iObjectWrapper = this.zzbqj.zzcf(string);
            if (iObjectWrapper != null) {
                return (View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to call getAssetView on delegate", remoteException);
        }
        return null;
    }

    public final View getHeadlineView() {
        return this.zzbj("3001");
    }

    public final View getCallToActionView() {
        return this.zzbj("3002");
    }

    public final View getIconView() {
        return this.zzbj("3003");
    }

    public final View getBodyView() {
        return this.zzbj("3004");
    }

    public final View getStoreView() {
        return this.zzbj("3006");
    }

    public final View getPriceView() {
        return this.zzbj("3007");
    }

    public final View getAdvertiserView() {
        return this.zzbj("3005");
    }

    public final View getImageView() {
        return this.zzbj("3008");
    }

    public final View getStarRatingView() {
        return this.zzbj("3009");
    }

    public final MediaView getMediaView() {
        View view = this.zzbj("3010");
        if (view instanceof MediaView) {
            return (MediaView)view;
        }
        if (view != null) {
            zzbae.zzdp("View is not an instance of MediaView");
        }
        return null;
    }

    public final AdChoicesView getAdChoicesView() {
        View view = this.zzbj("3011");
        if (view instanceof AdChoicesView) {
            return (AdChoicesView)view;
        }
        return null;
    }

    public final void destroy() {
        try {
            this.zzbqj.destroy();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zzc("Unable to destroy native ad view", remoteException);
            return;
        }
    }

    private final FrameLayout zzd(Context context) {
        Context context2 = context;
        FrameLayout frameLayout = new FrameLayout(context2);
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.addView((View)frameLayout);
        return frameLayout;
    }

    private final zzael zzks() {
        Preconditions.checkNotNull((Object)this.zzbqi, (Object)"createDelegate must be called after overlayFrame has been created");
        if (this.isInEditMode()) {
            return null;
        }
        return zzyr.zzpb().zza(this.zzbqi.getContext(), this, this.zzbqi);
    }

    public final void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, n, layoutParams);
        super.bringChildToFront((View)this.zzbqi);
    }

    public final void removeView(View view) {
        if (this.zzbqi == view) {
            return;
        }
        super.removeView(view);
    }

    public final void removeAllViews() {
        super.removeAllViews();
        super.addView((View)this.zzbqi);
    }

    public final void bringChildToFront(View view) {
        super.bringChildToFront(view);
        if (this.zzbqi != view) {
            super.bringChildToFront((View)this.zzbqi);
        }
    }

    public final void onVisibilityChanged(View view, int n) {
        super.onVisibilityChanged(view, n);
        if (this.zzbqj != null) {
            try {
                this.zzbqj.zzc(ObjectWrapper.wrap((Object)view), n);
                return;
            }
            catch (RemoteException remoteException) {
                zzbae.zzc("Unable to call onVisibilityChanged on delegate", remoteException);
            }
        }
    }
}

