/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.Correlator;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.VideoOptions;
import com.google.android.gms.ads.doubleclick.AppEventListener;
import com.google.android.gms.ads.doubleclick.OnCustomRenderedAdLoadedListener;
import com.google.android.gms.ads.zzb;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzaap;
import com.google.android.gms.internal.ads.zzaax;
import com.google.android.gms.internal.ads.zzaba;
import com.google.android.gms.internal.ads.zzacc;
import com.google.android.gms.internal.ads.zzadq;
import com.google.android.gms.internal.ads.zzamp;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzbae;
import com.google.android.gms.internal.ads.zzxp;
import com.google.android.gms.internal.ads.zzxq;
import com.google.android.gms.internal.ads.zzxt;
import com.google.android.gms.internal.ads.zzya;
import com.google.android.gms.internal.ads.zzyb;
import com.google.android.gms.internal.ads.zzyd;
import com.google.android.gms.internal.ads.zzye;
import com.google.android.gms.internal.ads.zzyf;
import com.google.android.gms.internal.ads.zzyg;
import com.google.android.gms.internal.ads.zzyi;
import com.google.android.gms.internal.ads.zzyr;
import com.google.android.gms.internal.ads.zzyt;
import com.google.android.gms.internal.ads.zzzi;
import java.util.concurrent.atomic.AtomicBoolean;

@zzare
public final class zzaaz {
    private final zzamp zzcjd = new zzamp();
    private final zzya zzaaj;
    private final AtomicBoolean zzcje;
    private final VideoController zzcjf = new VideoController();
    @VisibleForTesting
    private final zzyt zzcjg = new zzaba(this);
    private zzxp zzcgj;
    private AdListener zzcgm;
    private AdSize[] zzchk;
    private AppEventListener zzbqp;
    private Correlator zzcjh;
    private zzzi zzcji;
    private OnCustomRenderedAdLoadedListener zzcjj;
    private VideoOptions zzbqg;
    private String zzchl;
    private ViewGroup zzcjk;
    private int zzcjl;
    private boolean zzbqn;

    public zzaaz(ViewGroup viewGroup) {
        this(viewGroup, null, false, zzya.zzchf, 0);
    }

    public zzaaz(ViewGroup viewGroup, int n) {
        this(viewGroup, null, false, zzya.zzchf, n);
    }

    public zzaaz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl) {
        this(viewGroup, attributeSet, bl, zzya.zzchf, 0);
    }

    public zzaaz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, int n) {
        this(viewGroup, attributeSet, false, zzya.zzchf, n);
    }

    @VisibleForTesting
    private zzaaz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzya zzya2, zzzi zzzi2, int n) {
        this.zzcjk = viewGroup;
        this.zzaaj = zzya2;
        this.zzcji = null;
        this.zzcje = new AtomicBoolean(false);
        this.zzcjl = n;
        if (attributeSet != null) {
            Context context = viewGroup.getContext();
            try {
                zzye zzye2 = new zzye(context, attributeSet);
                this.zzchk = zzye2.zzs(bl);
                this.zzchl = zzye2.getAdUnitId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzyr.zzpa().zza(viewGroup, new zzyb(context, AdSize.BANNER), illegalArgumentException.getMessage(), illegalArgumentException.getMessage());
                return;
            }
            if (viewGroup.isInEditMode()) {
                boolean bl2;
                int n2 = this.zzcjl;
                AdSize adSize = this.zzchk[0];
                Context context2 = context;
                zzyb zzyb2 = new zzyb(context2, adSize);
                new zzyb(context2, adSize).zzchj = bl2 = zzaaz.zzcp(n2);
                zzyr.zzpa().zza(viewGroup, zzyb2, "Ads by Google");
            }
        }
    }

    @VisibleForTesting
    private zzaaz(ViewGroup viewGroup, AttributeSet attributeSet, boolean bl, zzya zzya2, int n) {
        this(viewGroup, attributeSet, bl, zzya2, null, n);
    }

    public final void destroy() {
        try {
            if (this.zzcji != null) {
                this.zzcji.destroy();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final AdListener getAdListener() {
        return this.zzcgm;
    }

    public final AdSize getAdSize() {
        try {
            zzyb zzyb2;
            if (this.zzcji != null && (zzyb2 = this.zzcji.zzpn()) != null) {
                zzyb zzyb3 = zzyb2;
                return zzb.zza(zzyb3.width, zzyb3.height, zzyb3.zzaap);
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
        }
        if (this.zzchk != null) {
            return this.zzchk[0];
        }
        return null;
    }

    public final AdSize[] getAdSizes() {
        return this.zzchk;
    }

    public final String getAdUnitId() {
        if (this.zzchl == null && this.zzcji != null) {
            try {
                this.zzchl = this.zzcji.getAdUnitId();
            }
            catch (RemoteException remoteException) {
                zzbae.zze("#007 Could not call remote method.", remoteException);
            }
        }
        return this.zzchl;
    }

    public final AppEventListener getAppEventListener() {
        return this.zzbqp;
    }

    public final OnCustomRenderedAdLoadedListener getOnCustomRenderedAdLoadedListener() {
        return this.zzcjj;
    }

    public final void zza(zzaax zzaax2) {
        try {
            if (this.zzcji == null) {
                zzzi zzzi2;
                zzyb zzyb2;
                zzaaz zzaaz2 = this;
                if ((zzaaz2.zzchk == null || zzaaz2.zzchl == null) && zzaaz2.zzcji == null) {
                    throw new IllegalStateException("The ad size and ad unit ID must be set before loadAd is called.");
                }
                zzaaz zzaaz3 = zzaaz2;
                Context context = zzaaz3.zzcjk.getContext();
                Object object = zzyb2 = zzaaz.zza(context, zzaaz3.zzchk, zzaaz3.zzcjl);
                if ("search_v2".equals(object.zzaap)) {
                    String string = zzaaz3.zzchl;
                    zzyb zzyb3 = zzyb2;
                    Context context2 = context;
                    object = zzyr.zzpb();
                    Context context3 = context2;
                    zzzi2 = (zzzi)new zzyi((zzyf)object, context2, zzyb3, string).zzd(context3, false);
                } else {
                    zzamp zzamp2 = zzaaz3.zzcjd;
                    String string = zzaaz3.zzchl;
                    zzyb zzyb4 = zzyb2;
                    Context context4 = context;
                    object = zzyr.zzpb();
                    Context context5 = context4;
                    zzzi2 = (zzzi)new zzyg((zzyf)object, context4, zzyb4, string, zzamp2).zzd(context5, false);
                }
                zzaaz2.zzcji = zzzi2;
                zzaaz2.zzcji.zzb(new zzxt(zzaaz2.zzcjg));
                if (zzaaz2.zzcgj != null) {
                    zzaaz2.zzcji.zza(new zzxq(zzaaz2.zzcgj));
                }
                if (zzaaz2.zzbqp != null) {
                    zzaaz2.zzcji.zza(new zzyd(zzaaz2.zzbqp));
                }
                if (zzaaz2.zzcjj != null) {
                    zzaaz2.zzcji.zza(new zzadq(zzaaz2.zzcjj));
                }
                if (zzaaz2.zzcjh != null) {
                    zzaaz2.zzcji.zzb(zzaaz2.zzcjh.zzdf());
                }
                if (zzaaz2.zzbqg != null) {
                    zzaaz2.zzcji.zza(new zzacc(zzaaz2.zzbqg));
                }
                zzaaz2.zzcji.setManualImpressionsEnabled(zzaaz2.zzbqn);
                zzaaz zzaaz4 = zzaaz2;
                try {
                    IObjectWrapper iObjectWrapper = zzaaz4.zzcji.zzpl();
                    if (iObjectWrapper != null) {
                        zzaaz4.zzcjk.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
                    }
                }
                catch (RemoteException remoteException) {
                    zzbae.zze("#007 Could not call remote method.", remoteException);
                }
            }
            if (this.zzcji.zzb(zzya.zza(this.zzcjk.getContext(), zzaax2))) {
                this.zzcjd.zzf(zzaax2.zzqa());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void pause() {
        try {
            if (this.zzcji != null) {
                this.zzcji.pause();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void recordManualImpression() {
        if (this.zzcje.getAndSet(true)) {
            return;
        }
        try {
            if (this.zzcji != null) {
                this.zzcji.zzpm();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void resume() {
        try {
            if (this.zzcji != null) {
                this.zzcji.resume();
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdListener(AdListener adListener) {
        this.zzcgm = adListener;
        this.zzcjg.zza(adListener);
    }

    public final void zza(zzxp zzxp2) {
        try {
            this.zzcgj = zzxp2;
            if (this.zzcji != null) {
                this.zzcji.zza(zzxp2 != null ? new zzxq(zzxp2) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setAdSizes(AdSize ... adSizeArray) {
        if (this.zzchk != null) {
            throw new IllegalStateException("The ad size can only be set once on AdView.");
        }
        this.zza(adSizeArray);
    }

    public final void zza(AdSize ... adSizeArray) {
        this.zzchk = adSizeArray;
        try {
            if (this.zzcji != null) {
                this.zzcji.zza(zzaaz.zza(this.zzcjk.getContext(), this.zzchk, this.zzcjl));
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
        }
        this.zzcjk.requestLayout();
    }

    public final void setAdUnitId(String string) {
        if (this.zzchl != null) {
            throw new IllegalStateException("The ad unit ID can only be set once on AdView.");
        }
        this.zzchl = string;
    }

    public final void setAppEventListener(AppEventListener appEventListener) {
        try {
            this.zzbqp = appEventListener;
            if (this.zzcji != null) {
                this.zzcji.zza(appEventListener != null ? new zzyd(appEventListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setOnCustomRenderedAdLoadedListener(OnCustomRenderedAdLoadedListener onCustomRenderedAdLoadedListener) {
        this.zzcjj = onCustomRenderedAdLoadedListener;
        try {
            if (this.zzcji != null) {
                this.zzcji.zza(onCustomRenderedAdLoadedListener != null ? new zzadq(onCustomRenderedAdLoadedListener) : null);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setManualImpressionsEnabled(boolean bl) {
        this.zzbqn = bl;
        try {
            if (this.zzcji != null) {
                this.zzcji.setManualImpressionsEnabled(this.zzbqn);
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final void setCorrelator(Correlator correlator) {
        this.zzcjh = correlator;
        try {
            if (this.zzcji != null) {
                this.zzcji.zzb(this.zzcjh == null ? null : this.zzcjh.zzdf());
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final String getMediationAdapterClassName() {
        try {
            if (this.zzcji != null) {
                return this.zzcji.zzpj();
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
        }
        return null;
    }

    public final boolean isLoading() {
        try {
            if (this.zzcji != null) {
                return this.zzcji.isLoading();
            }
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
        }
        return false;
    }

    public final VideoController getVideoController() {
        return this.zzcjf;
    }

    public final zzaap zzdh() {
        if (this.zzcji == null) {
            return null;
        }
        try {
            return this.zzcji.getVideoController();
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return null;
        }
    }

    public final void setVideoOptions(VideoOptions videoOptions) {
        this.zzbqg = videoOptions;
        try {
            if (this.zzcji != null) {
                this.zzcji.zza(videoOptions == null ? null : new zzacc(videoOptions));
            }
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final VideoOptions getVideoOptions() {
        return this.zzbqg;
    }

    public final boolean zza(zzzi zzzi2) {
        IObjectWrapper iObjectWrapper;
        if (zzzi2 == null) {
            return false;
        }
        try {
            iObjectWrapper = zzzi2.zzpl();
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return false;
        }
        if (iObjectWrapper == null) {
            return false;
        }
        if (((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper)).getParent() != null) {
            return false;
        }
        this.zzcjk.addView((View)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper));
        this.zzcji = zzzi2;
        return true;
    }

    private static zzyb zza(Context context, AdSize[] adSizeArray, int n) {
        boolean bl;
        zzyb zzyb2 = new zzyb(context, adSizeArray);
        new zzyb(context, adSizeArray).zzchj = bl = zzaaz.zzcp(n);
        return zzyb2;
    }

    private static boolean zzcp(int n) {
        return n == 1;
    }

    static /* synthetic */ VideoController zza(zzaaz zzaaz2) {
        return zzaaz2.zzcjf;
    }
}

