/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzamj;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzbae;
import javax.annotation.Nonnull;

@zzare
public final class zzabg
extends ContentProvider {
    public final void attachInfo(Context context, ProviderInfo providerInfo) {
        Bundle bundle = zzabg.zzh(context);
        Context context2 = context;
        String string = null;
        Boolean bl = null;
        if (bundle != null) {
            try {
                string = (String)bundle.get("com.google.android.gms.ads.APPLICATION_ID");
            }
            catch (ClassCastException classCastException) {
                zzbae.zzen("The com.google.android.gms.ads.APPLICATION_ID metadata must have a String value");
            }
            try {
                bl = (Boolean)bundle.get("com.google.android.gms.ads.AD_MANAGER_APP");
            }
            catch (ClassCastException classCastException) {
                zzbae.zzen("The com.google.android.gms.ads.AD_MANAGER_APP metadata must have a boolean value");
            }
        }
        if (!(bl != null && bl.booleanValue() || string != null)) {
            throw new IllegalStateException("\n\n******************************************************************************\n* The Google Mobile Ads SDK was initialized incorrectly. AdMob publishers    *\n* should follow the instructions here: https://goo.gl/fQ2neu to add a valid  *\n* App ID inside the AndroidManifest. Google Ad Manager publishers should     *\n* follow instructions here: https://goo.gl/h17b6x.                           *\n******************************************************************************\n\n");
        }
        if (string != null) {
            if (!string.matches("^ca-app-pub-[0-9]{16}~[0-9]{10}$")) {
                throw new IllegalStateException("\n\n******************************************************************************\n* Invalid application ID. Follow instructions here: https://goo.gl/fQ2neu to *\n* find your app ID.                                                          *\n******************************************************************************\n\n");
            }
            String string2 = String.valueOf(string);
            zzbae.zzdp(string2.length() != 0 ? "Publisher provided Google AdMob App ID in manifest: ".concat(string2) : new String("Publisher provided Google AdMob App ID in manifest: "));
            zzamj.initialize(context2, string);
        }
        super.attachInfo(context, providerInfo);
    }

    @Nullable
    private static Bundle zzh(Context context) {
        try {
            return Wrappers.packageManager((Context)context).getApplicationInfo((String)context.getPackageName(), (int)128).metaData;
        }
        catch (NullPointerException nullPointerException) {
            zzbae.zzc("Failed to load metadata: Null pointer exception", nullPointerException);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            zzbae.zzc("Failed to load metadata: Package name not found", nameNotFoundException);
        }
        return null;
    }

    public final boolean onCreate() {
        return false;
    }

    @Nullable
    public final Cursor query(@Nonnull Uri uri, String[] stringArray, String string, String[] stringArray2, String string2) {
        return null;
    }

    @Nullable
    public final String getType(@NonNull Uri uri) {
        return null;
    }

    @Nullable
    public final Uri insert(@NonNull Uri uri, ContentValues contentValues) {
        return null;
    }

    public final int delete(@NonNull Uri uri, String string, String[] stringArray) {
        return 0;
    }

    public final int update(@NonNull Uri uri, ContentValues contentValues, String string, String[] stringArray) {
        return 0;
    }
}

