/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.support.annotation.Nullable;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.VideoController;
import com.google.android.gms.ads.formats.NativeCustomTemplateAd;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeAdMapper;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzafg;
import com.google.android.gms.internal.ads.zzamw;
import com.google.android.gms.internal.ads.zzank;
import com.google.android.gms.internal.ads.zzare;
import com.google.android.gms.internal.ads.zzbae;

@zzare
public final class zzanp
implements MediationBannerListener,
MediationInterstitialListener,
MediationNativeListener {
    private final zzamw zzdgn;
    private NativeAdMapper zzdgo;
    private UnifiedNativeAdMapper zzdgp;
    private NativeCustomTemplateAd zzdgq;

    public zzanp(zzamw zzamw2) {
        this.zzdgn = zzamw2;
    }

    @Override
    public final void zza(MediationBannerAdapter mediationBannerAdapter, String string, String string2) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAppEvent.");
        try {
            this.zzdgn.onAppEvent(string, string2);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdClicked.");
        try {
            this.zzdgn.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdClosed.");
        try {
            this.zzdgn.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationBannerAdapter mediationBannerAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error. ").append(n).toString());
        try {
            this.zzdgn.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLeftApplication.");
        try {
            this.zzdgn.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdOpened.");
        try {
            this.zzdgn.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationBannerAdapter mediationBannerAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLoaded.");
        try {
            this.zzdgn.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdClicked.");
        try {
            this.zzdgn.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdClosed.");
        try {
            this.zzdgn.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdFailedToLoad(MediationInterstitialAdapter mediationInterstitialAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdgn.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLeftApplication.");
        try {
            this.zzdgn.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdOpened.");
        try {
            this.zzdgn.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationInterstitialAdapter mediationInterstitialAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLoaded.");
        try {
            this.zzdgn.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, NativeAdMapper nativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLoaded.");
        this.zzdgo = nativeAdMapper;
        this.zzdgp = null;
        zzanp.zza(mediationNativeAdapter, this.zzdgp, this.zzdgo);
        try {
            this.zzdgn.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLoaded(MediationNativeAdapter mediationNativeAdapter, UnifiedNativeAdMapper unifiedNativeAdMapper) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLoaded.");
        this.zzdgp = unifiedNativeAdMapper;
        this.zzdgo = null;
        zzanp.zza(mediationNativeAdapter, this.zzdgp, this.zzdgo);
        try {
            this.zzdgn.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    private static void zza(MediationNativeAdapter mediationNativeAdapter, @Nullable UnifiedNativeAdMapper unifiedNativeAdMapper, @Nullable NativeAdMapper nativeAdMapper) {
        if (mediationNativeAdapter instanceof AdMobAdapter) {
            return;
        }
        VideoController videoController = new VideoController();
        videoController.zza(new zzank());
        if (unifiedNativeAdMapper != null && unifiedNativeAdMapper.hasVideoContent()) {
            unifiedNativeAdMapper.zza(videoController);
        }
        if (nativeAdMapper != null && nativeAdMapper.hasVideoContent()) {
            nativeAdMapper.zza(videoController);
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        String string = String.valueOf(nativeCustomTemplateAd.getCustomTemplateId());
        zzbae.zzdp(string.length() != 0 ? "Adapter called onAdLoaded with template id ".concat(string) : new String("Adapter called onAdLoaded with template id "));
        this.zzdgq = nativeCustomTemplateAd;
        try {
            this.zzdgn.onAdLoaded();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void zza(MediationNativeAdapter mediationNativeAdapter, NativeCustomTemplateAd nativeCustomTemplateAd, String string) {
        if (nativeCustomTemplateAd instanceof zzafg) {
            try {
                this.zzdgn.zza(((zzafg)nativeCustomTemplateAd).zzrn(), string);
                return;
            }
            catch (RemoteException remoteException) {
                zzbae.zze("#007 Could not call remote method.", remoteException);
                return;
            }
        }
        zzbae.zzep("Unexpected native custom template ad type.");
    }

    @Override
    public final void onAdFailedToLoad(MediationNativeAdapter mediationNativeAdapter, int n) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp(new StringBuilder(55).append("Adapter called onAdFailedToLoad with error ").append(n).append(".").toString());
        try {
            this.zzdgn.onAdFailedToLoad(n);
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdOpened(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdOpened.");
        try {
            this.zzdgn.onAdOpened();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClosed(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdClosed.");
        try {
            this.zzdgn.onAdClosed();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdLeftApplication(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onAdLeftApplication.");
        try {
            this.zzdgn.onAdLeftApplication();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdClicked(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdgo;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdgp;
        if (this.zzdgq == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzbae.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideClickHandling()) {
                zzbae.zzdp("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideClickHandling()) {
                zzbae.zzdp("Could not call onAdClicked since setOverrideClickHandling is not set to true");
                return;
            }
        }
        zzbae.zzdp("Adapter called onAdClicked.");
        try {
            this.zzdgn.onAdClicked();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onAdImpression(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        NativeAdMapper nativeAdMapper = this.zzdgo;
        UnifiedNativeAdMapper unifiedNativeAdMapper = this.zzdgp;
        if (this.zzdgq == null) {
            if (nativeAdMapper == null && unifiedNativeAdMapper == null) {
                zzbae.zze("#007 Could not call remote method.", null);
                return;
            }
            if (unifiedNativeAdMapper != null && !unifiedNativeAdMapper.getOverrideImpressionRecording()) {
                zzbae.zzdp("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
            if (nativeAdMapper != null && !nativeAdMapper.getOverrideImpressionRecording()) {
                zzbae.zzdp("Could not call onAdImpression since setOverrideImpressionRecording is not set to true");
                return;
            }
        }
        zzbae.zzdp("Adapter called onAdImpression.");
        try {
            this.zzdgn.onAdImpression();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    @Override
    public final void onVideoEnd(MediationNativeAdapter mediationNativeAdapter) {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzbae.zzdp("Adapter called onVideoEnd.");
        try {
            this.zzdgn.onVideoEnd();
            return;
        }
        catch (RemoteException remoteException) {
            zzbae.zze("#007 Could not call remote method.", remoteException);
            return;
        }
    }

    public final NativeAdMapper zzsr() {
        return this.zzdgo;
    }

    public final UnifiedNativeAdMapper zzss() {
        return this.zzdgp;
    }

    public final NativeCustomTemplateAd zzst() {
        return this.zzdgq;
    }
}

