/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.accounts.Account;
import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.support.annotation.BinderThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.CommonStatusCodes;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.internal.GetServiceRequest;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.IGmsCallbacks;
import com.google.android.gms.common.internal.IGmsServiceBroker;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.zzh;
import com.google.android.gms.common.util.VisibleForTesting;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

@KeepForSdk
public abstract class BaseGmsClient<T extends IInterface> {
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTED = 1;
    @KeepForSdk
    public static final int CONNECT_STATE_CONNECTED = 4;
    @KeepForSdk
    public static final int CONNECT_STATE_DISCONNECTING = 5;
    private static final Feature[] zzbt = new Feature[0];
    @KeepForSdk
    public static final String KEY_PENDING_INTENT = "pendingIntent";
    private int zzbu;
    private long zzbv;
    private long zzbw;
    private int zzbx;
    private long zzby;
    @VisibleForTesting
    private zzh zzbz;
    @KeepForSdk
    public static final String DEFAULT_ACCOUNT = "<<default account>>";
    private final Context mContext;
    private final Looper zzca;
    private final GmsClientSupervisor zzcb;
    private final GoogleApiAvailabilityLight zzcc;
    final Handler mHandler;
    private final Object mLock = new Object();
    private final Object zzcd = new Object();
    @GuardedBy(value="mServiceBrokerLock")
    private IGmsServiceBroker zzce;
    @VisibleForTesting
    protected ConnectionProgressReportCallbacks zzcf;
    @GuardedBy(value="mLock")
    private T zzcg;
    private final ArrayList<zzc<?>> zzch = new ArrayList();
    @GuardedBy(value="mLock")
    private zze zzci;
    @GuardedBy(value="mLock")
    private int zzcj = 1;
    private final BaseConnectionCallbacks zzck;
    private final BaseOnConnectionFailedListener zzcl;
    private final int zzcm;
    private final String zzcn;
    private ConnectionResult zzco = null;
    private boolean zzcp = false;
    private volatile com.google.android.gms.common.internal.zzb zzcq = null;
    @VisibleForTesting
    protected AtomicInteger zzcr = new AtomicInteger(0);
    @KeepForSdk
    public static final String[] GOOGLE_PLUS_REQUIRED_FEATURES = new String[]{"service_esmobile", "service_googleme"};

    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this(context, looper, GmsClientSupervisor.getInstance(context), GoogleApiAvailabilityLight.getInstance(), n, Preconditions.checkNotNull(baseConnectionCallbacks), Preconditions.checkNotNull(baseOnConnectionFailedListener), string2);
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Looper looper, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener, String string2) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.zzca = Preconditions.checkNotNull(looper, "Looper must not be null");
        this.zzcb = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcc = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.mHandler = new zzb(looper);
        this.zzcm = n;
        this.zzck = baseConnectionCallbacks;
        this.zzcl = baseOnConnectionFailedListener;
        this.zzcn = string2;
    }

    @VisibleForTesting
    @KeepForSdk
    protected BaseGmsClient(Context context, Handler handler, GmsClientSupervisor gmsClientSupervisor, GoogleApiAvailabilityLight googleApiAvailabilityLight, int n, BaseConnectionCallbacks baseConnectionCallbacks, BaseOnConnectionFailedListener baseOnConnectionFailedListener) {
        this.mContext = Preconditions.checkNotNull(context, "Context must not be null");
        this.mHandler = Preconditions.checkNotNull(handler, "Handler must not be null");
        this.zzca = handler.getLooper();
        this.zzcb = Preconditions.checkNotNull(gmsClientSupervisor, "Supervisor must not be null");
        this.zzcc = Preconditions.checkNotNull(googleApiAvailabilityLight, "API availability must not be null");
        this.zzcm = n;
        this.zzck = baseConnectionCallbacks;
        this.zzcl = baseOnConnectionFailedListener;
        this.zzcn = null;
    }

    @NonNull
    @KeepForSdk
    protected abstract String getStartServiceAction();

    @KeepForSdk
    protected String getStartServicePackage() {
        return "com.google.android.gms";
    }

    @NonNull
    @KeepForSdk
    protected abstract String getServiceDescriptor();

    @Nullable
    private final String zzj() {
        if (this.zzcn == null) {
            return this.mContext.getClass().getName();
        }
        return this.zzcn;
    }

    @Nullable
    @KeepForSdk
    protected String getLocalStartServiceAction() {
        return null;
    }

    private final void zza(com.google.android.gms.common.internal.zzb zzb2) {
        this.zzcq = zzb2;
    }

    @Nullable
    @KeepForSdk
    public final Feature[] getAvailableFeatures() {
        com.google.android.gms.common.internal.zzb zzb2 = this.zzcq;
        if (zzb2 == null) {
            return null;
        }
        return zzb2.zzdb;
    }

    @Nullable
    @KeepForSdk
    protected abstract T createServiceInterface(IBinder var1);

    @CallSuper
    @KeepForSdk
    protected void onConnectedLocked(@NonNull T t) {
        this.zzbw = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionSuspended(int n) {
        this.zzbu = n;
        this.zzbv = System.currentTimeMillis();
    }

    @CallSuper
    @KeepForSdk
    protected void onConnectionFailed(ConnectionResult connectionResult) {
        this.zzbx = connectionResult.getErrorCode();
        this.zzby = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zza(int n, T t) {
        Preconditions.checkArgument(n == 4 == (t != null));
        Object object = this.mLock;
        synchronized (object) {
            this.zzcj = n;
            this.zzcg = t;
            this.onSetConnectState(n, t);
            switch (n) {
                case 2: 
                case 3: {
                    String string2;
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzci != null && baseGmsClient.zzbz != null) {
                        String string3 = baseGmsClient.zzbz.zzt();
                        string2 = baseGmsClient.zzbz.getPackageName();
                        Log.e((String)"GmsClient", (String)new StringBuilder(70 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Calling connect() while still connected, missing disconnect() for ").append(string3).append(" on ").append(string2).toString());
                        baseGmsClient.zzcb.zza(baseGmsClient.zzbz.zzt(), baseGmsClient.zzbz.getPackageName(), baseGmsClient.zzbz.zzq(), baseGmsClient.zzci, baseGmsClient.zzj());
                        baseGmsClient.zzcr.incrementAndGet();
                    }
                    baseGmsClient.zzci = baseGmsClient.new zze(baseGmsClient.zzcr.get());
                    BaseGmsClient baseGmsClient2 = baseGmsClient;
                    baseGmsClient.zzbz = baseGmsClient2.zzcj == 3 && baseGmsClient2.getLocalStartServiceAction() != null ? new zzh(baseGmsClient2.getContext().getPackageName(), baseGmsClient2.getLocalStartServiceAction(), true, 129) : new zzh(baseGmsClient2.getStartServicePackage(), baseGmsClient2.getStartServiceAction(), false, 129);
                    String string4 = baseGmsClient.zzj();
                    zze zze2 = baseGmsClient.zzci;
                    int n2 = baseGmsClient.zzbz.zzq();
                    String string5 = baseGmsClient.zzbz.getPackageName();
                    String string6 = baseGmsClient.zzbz.zzt();
                    if (baseGmsClient.zzcb.zza(new GmsClientSupervisor.zza(string6, string5, n2), zze2, string4)) break;
                    string2 = baseGmsClient.zzbz.zzt();
                    String string7 = baseGmsClient.zzbz.getPackageName();
                    Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string7).length()).append("unable to connect to service: ").append(string2).append(" on ").append(string7).toString());
                    baseGmsClient.zza(16, null, baseGmsClient.zzcr.get());
                    break;
                }
                case 4: {
                    this.onConnectedLocked(t);
                    break;
                }
                case 1: {
                    BaseGmsClient baseGmsClient = this;
                    if (baseGmsClient.zzci == null) break;
                    baseGmsClient.zzcb.zza(baseGmsClient.zzbz.zzt(), baseGmsClient.zzbz.getPackageName(), baseGmsClient.zzbz.zzq(), baseGmsClient.zzci, baseGmsClient.zzj());
                    baseGmsClient.zzci = null;
                }
            }
            return;
        }
    }

    @KeepForSdk
    void onSetConnectState(int n, T t) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zza(int n, int n2, T t) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcj != n) {
                return false;
            }
            this.zza(n2, t);
            return true;
        }
    }

    @KeepForSdk
    public void checkAvailabilityAndConnect() {
        int n = this.zzcc.isGooglePlayServicesAvailable(this.mContext, this.getMinApkVersion());
        if (n != 0) {
            this.zza(1, null);
            this.triggerNotAvailable(new LegacyClientCallbackAdapter(), n, null);
            return;
        }
        this.connect(new LegacyClientCallbackAdapter());
    }

    @KeepForSdk
    public void connect(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        this.zzcf = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.zza(2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnected() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcj == 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public boolean isConnecting() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcj == 2 || this.zzcj == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean zzk() {
        Object object = this.mLock;
        synchronized (object) {
            return this.zzcj == 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void disconnect() {
        this.zzcr.incrementAndGet();
        Object object = this.zzch;
        synchronized (object) {
            int n = this.zzch.size();
            for (int i = 0; i < n; ++i) {
                this.zzch.get(i).removeListener();
            }
            this.zzch.clear();
        }
        object = this.zzcd;
        synchronized (object) {
            this.zzce = null;
        }
        this.zza(1, null);
    }

    @KeepForSdk
    public void triggerConnectionSuspended(int n) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(6, this.zzcr.get(), n));
    }

    private final void zzb(int n) {
        int n2;
        if (this.zzk()) {
            n2 = 5;
            this.zzcp = true;
        } else {
            n2 = 4;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(n2, this.zzcr.get(), 16));
    }

    @VisibleForTesting
    @KeepForSdk
    protected void triggerNotAvailable(@NonNull ConnectionProgressReportCallbacks connectionProgressReportCallbacks, int n, @Nullable PendingIntent pendingIntent) {
        this.zzcf = Preconditions.checkNotNull(connectionProgressReportCallbacks, "Connection progress callbacks cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(3, this.zzcr.get(), n, (Object)pendingIntent));
    }

    @KeepForSdk
    public final Context getContext() {
        return this.mContext;
    }

    @KeepForSdk
    public final Looper getLooper() {
        return this.zzca;
    }

    @KeepForSdk
    public Account getAccount() {
        return null;
    }

    @KeepForSdk
    public Feature[] getApiFeatures() {
        return zzbt;
    }

    @KeepForSdk
    protected Bundle getGetServiceRequestExtraArgs() {
        return new Bundle();
    }

    @KeepForSdk
    protected void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, n2, -1, (Object)new zzf(n, iBinder, bundle)));
    }

    protected final void zza(int n, @Nullable Bundle bundle, int n2) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(7, n2, -1, (Object)new zzg(n, null)));
    }

    @KeepForSdk
    protected final void checkConnected() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    @KeepForSdk
    public Bundle getConnectionHint() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public final T getService() throws DeadObjectException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.zzcj == 5) {
                throw new DeadObjectException();
            }
            this.checkConnected();
            Preconditions.checkState(this.zzcg != null, "Client is connected but service is null");
            return this.zzcg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    @KeepForSdk
    public void getRemoteService(IAccountAccessor iAccountAccessor, Set<Scope> set) {
        Bundle bundle = this.getGetServiceRequestExtraArgs();
        Object object = this.mContext.getPackageName();
        Object object2 = new GetServiceRequest(this.zzcm);
        new GetServiceRequest(this.zzcm).zzy = object;
        object = bundle;
        v0.zzdk = object;
        GetServiceRequest getServiceRequest = object2;
        if (set != null) {
            object = set;
            getServiceRequest.zzdj = object.toArray(new Scope[object.size()]);
        }
        if (this.requiresSignIn()) {
            object2 = this;
            object = ((BaseGmsClient)object2).getAccount() != null ? ((BaseGmsClient)object2).getAccount() : new Account(DEFAULT_ACCOUNT, "com.google");
            object2 = getServiceRequest;
            getServiceRequest.zzdl = object;
            object = iAccountAccessor;
            if (object != null) {
                ((GetServiceRequest)object2).zzdi = object.asBinder();
            }
        } else if (this.requiresAccount()) {
            object = this.getAccount();
            getServiceRequest.zzdl = object;
        }
        object = zzbt;
        getServiceRequest.zzdm = zzbt;
        object = this.getApiFeatures();
        getServiceRequest.zzdn = object;
        try {
            Object object3 = this.zzcd;
            synchronized (object3) {
                if (this.zzce != null) {
                    this.zzce.getService(new zzd(this, this.zzcr.get()), getServiceRequest);
                } else {
                    Log.w((String)"GmsClient", (String)"mServiceBroker is null, client disconnected");
                }
                return;
            }
        }
        catch (DeadObjectException deadObjectException) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)deadObjectException);
            this.triggerConnectionSuspended(1);
            return;
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (RemoteException | RuntimeException throwable) {
            Log.w((String)"GmsClient", (String)"IGmsServiceBroker.getService failed", (Throwable)throwable);
            this.onPostInitHandler(8, null, null, this.zzcr.get());
            return;
        }
    }

    @KeepForSdk
    protected boolean enableLocalFallback() {
        return false;
    }

    @KeepForSdk
    public boolean requiresSignIn() {
        return false;
    }

    @KeepForSdk
    public void onUserSignOut(@NonNull SignOutCallbacks signOutCallbacks) {
        signOutCallbacks.onSignOutComplete();
    }

    @KeepForSdk
    public boolean requiresAccount() {
        return false;
    }

    @KeepForSdk
    public boolean requiresGooglePlayServices() {
        return true;
    }

    @KeepForSdk
    public boolean providesSignIn() {
        return false;
    }

    @KeepForSdk
    public Intent getSignInIntent() {
        throw new UnsupportedOperationException("Not a sign in API");
    }

    @KeepForSdk
    protected Set<Scope> getScopes() {
        return Collections.EMPTY_SET;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KeepForSdk
    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        String string3;
        long l;
        IGmsServiceBroker iGmsServiceBroker;
        T t;
        int n;
        Object object = this.mLock;
        synchronized (object) {
            n = this.zzcj;
            t = this.zzcg;
        }
        object = this.zzcd;
        synchronized (object) {
            iGmsServiceBroker = this.zzce;
        }
        printWriter.append(string2).append("mConnectState=");
        switch (n) {
            case 2: {
                printWriter.print("REMOTE_CONNECTING");
                break;
            }
            case 3: {
                printWriter.print("LOCAL_CONNECTING");
                break;
            }
            case 4: {
                printWriter.print("CONNECTED");
                break;
            }
            case 5: {
                printWriter.print("DISCONNECTING");
                break;
            }
            case 1: {
                printWriter.print("DISCONNECTED");
                break;
            }
            default: {
                printWriter.print("UNKNOWN");
            }
        }
        printWriter.append(" mService=");
        if (t == null) {
            printWriter.append("null");
        } else {
            printWriter.append(this.getServiceDescriptor()).append("@").append(Integer.toHexString(System.identityHashCode(t.asBinder())));
        }
        printWriter.append(" mServiceBroker=");
        if (iGmsServiceBroker == null) {
            printWriter.println("null");
        } else {
            printWriter.append("IGmsServiceBroker@").println(Integer.toHexString(System.identityHashCode(iGmsServiceBroker.asBinder())));
        }
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS", Locale.US);
        if (this.zzbw > 0L) {
            l = this.zzbw;
            string3 = ((DateFormat)object).format(new Date(this.zzbw));
            printWriter.append(string2).append("lastConnectedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzbv > 0L) {
            printWriter.append(string2).append("lastSuspendedCause=");
            switch (this.zzbu) {
                case 1: {
                    printWriter.append("CAUSE_SERVICE_DISCONNECTED");
                    break;
                }
                case 2: {
                    printWriter.append("CAUSE_NETWORK_LOST");
                    break;
                }
                default: {
                    printWriter.append(String.valueOf(this.zzbu));
                }
            }
            l = this.zzbv;
            string3 = ((DateFormat)object).format(new Date(this.zzbv));
            printWriter.append(" lastSuspendedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
        if (this.zzby > 0L) {
            printWriter.append(string2).append("lastFailedStatus=").append(CommonStatusCodes.getStatusCodeString(this.zzbx));
            l = this.zzby;
            string3 = ((DateFormat)object).format(new Date(this.zzby));
            printWriter.append(" lastFailedTime=").println(new StringBuilder(21 + String.valueOf(string3).length()).append(l).append(" ").append(string3).toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @KeepForSdk
    public IBinder getServiceBrokerBinder() {
        Object object = this.zzcd;
        synchronized (object) {
            if (this.zzce == null) {
                return null;
            }
            return this.zzce.asBinder();
        }
    }

    private final boolean zzl() {
        if (this.zzcp) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getServiceDescriptor())) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)this.getLocalStartServiceAction())) {
            return false;
        }
        try {
            Class.forName(this.getServiceDescriptor());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    @KeepForSdk
    public String getEndpointPackageName() {
        if (this.isConnected() && this.zzbz != null) {
            return this.zzbz.getPackageName();
        }
        throw new RuntimeException("Failed to connect when checking package");
    }

    @KeepForSdk
    public int getMinApkVersion() {
        return GoogleApiAvailabilityLight.GOOGLE_PLAY_SERVICES_VERSION_CODE;
    }

    @VisibleForTesting
    public static final class zzd
    extends IGmsCallbacks.zza {
        private BaseGmsClient zzcw;
        private final int zzcx;

        public zzd(@NonNull BaseGmsClient baseGmsClient, int n) {
            this.zzcw = baseGmsClient;
            this.zzcx = n;
        }

        @Override
        @BinderThread
        public final void zza(int n, @Nullable Bundle bundle) {
            Log.wtf((String)"GmsClient", (String)"received deprecated onAccountValidationComplete callback, ignoring", (Throwable)new Exception());
        }

        @Override
        @BinderThread
        public final void onPostInitComplete(int n, @NonNull IBinder iBinder, @Nullable Bundle bundle) {
            Preconditions.checkNotNull(this.zzcw, "onPostInitComplete can be called only once per call to getRemoteService");
            this.zzcw.onPostInitHandler(n, iBinder, bundle, this.zzcx);
            this.zzcw = null;
        }

        @Override
        @BinderThread
        public final void zza(int n, @NonNull IBinder iBinder, @NonNull com.google.android.gms.common.internal.zzb zzb2) {
            Preconditions.checkNotNull(this.zzcw, "onPostInitCompleteWithConnectionInfo can be called only once per call togetRemoteService");
            Preconditions.checkNotNull(zzb2);
            this.zzcw.zza(zzb2);
            this.onPostInitComplete(n, iBinder, zzb2.zzda);
        }
    }

    private abstract class zza
    extends zzc<Boolean> {
        private final int statusCode;
        private final Bundle zzcs;

        @BinderThread
        protected zza(int n, Bundle bundle) {
            super(true);
            this.statusCode = n;
            this.zzcs = bundle;
        }

        protected abstract boolean zzm();

        @Override
        protected abstract void zza(ConnectionResult var1);

        @Override
        protected final void zzn() {
        }

        @Override
        protected final /* synthetic */ void zza(Object object) {
            Boolean bl = (Boolean)object;
            zza zza2 = this;
            if (bl == null) {
                zza2.BaseGmsClient.this.zza(1, null);
                return;
            }
            switch (zza2.statusCode) {
                case 0: {
                    if (zza2.zzm()) break;
                    zza2.BaseGmsClient.this.zza(1, null);
                    zza2.zza(new ConnectionResult(8, null));
                    return;
                }
                case 10: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    throw new IllegalStateException(String.format("A fatal developer error has occurred. Class name: %s. Start service action: %s. Service Descriptor: %s. ", zza2.getClass().getSimpleName(), zza2.BaseGmsClient.this.getStartServiceAction(), zza2.BaseGmsClient.this.getServiceDescriptor()));
                }
                default: {
                    zza2.BaseGmsClient.this.zza(1, null);
                    PendingIntent pendingIntent = null;
                    if (zza2.zzcs != null) {
                        pendingIntent = (PendingIntent)zza2.zzcs.getParcelable(BaseGmsClient.KEY_PENDING_INTENT);
                    }
                    zza2.zza(new ConnectionResult(zza2.statusCode, pendingIntent));
                }
            }
        }
    }

    protected final class zzf
    extends zza {
        private final IBinder zzcy;

        @BinderThread
        public zzf(int n, IBinder iBinder, Bundle bundle) {
            super(n, bundle);
            this.zzcy = iBinder;
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.zzcl != null) {
                BaseGmsClient.this.zzcl.onConnectionFailed(connectionResult);
            }
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzm() {
            String string2;
            try {
                string2 = this.zzcy.getInterfaceDescriptor();
            }
            catch (RemoteException remoteException) {
                Log.w((String)"GmsClient", (String)"service probably died");
                return false;
            }
            if (!BaseGmsClient.this.getServiceDescriptor().equals(string2)) {
                String string3 = BaseGmsClient.this.getServiceDescriptor();
                Log.e((String)"GmsClient", (String)new StringBuilder(34 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("service descriptor mismatch: ").append(string3).append(" vs. ").append(string2).toString());
                return false;
            }
            Object t = BaseGmsClient.this.createServiceInterface(this.zzcy);
            if (t != null && (BaseGmsClient.this.zza(2, 4, t) || BaseGmsClient.this.zza(3, 4, t))) {
                BaseGmsClient.this.zzco = null;
                Bundle bundle = BaseGmsClient.this.getConnectionHint();
                if (BaseGmsClient.this.zzck != null) {
                    BaseGmsClient.this.zzck.onConnected(bundle);
                }
                return true;
            }
            return false;
        }
    }

    protected final class zzg
    extends zza {
        @BinderThread
        public zzg(@Nullable int n, Bundle bundle) {
            super(n, null);
        }

        @Override
        protected final void zza(ConnectionResult connectionResult) {
            if (BaseGmsClient.this.enableLocalFallback() && BaseGmsClient.this.zzl()) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            BaseGmsClient.this.zzcf.onReportServiceBinding(connectionResult);
            BaseGmsClient.this.onConnectionFailed(connectionResult);
        }

        @Override
        protected final boolean zzm() {
            BaseGmsClient.this.zzcf.onReportServiceBinding(ConnectionResult.RESULT_SUCCESS);
            return true;
        }
    }

    protected class LegacyClientCallbackAdapter
    implements ConnectionProgressReportCallbacks {
        @KeepForSdk
        public LegacyClientCallbackAdapter() {
        }

        @Override
        public void onReportServiceBinding(@NonNull ConnectionResult connectionResult) {
            if (connectionResult.isSuccess()) {
                BaseGmsClient.this.getRemoteService(null, BaseGmsClient.this.getScopes());
                return;
            }
            if (BaseGmsClient.this.zzcl != null) {
                BaseGmsClient.this.zzcl.onConnectionFailed(connectionResult);
            }
        }
    }

    protected abstract class zzc<TListener> {
        private TListener zzcu;
        private boolean zzcv;

        public zzc(TListener TListener) {
            this.zzcu = TListener;
            this.zzcv = false;
        }

        protected abstract void zza(TListener var1);

        protected abstract void zzn();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void zzo() {
            TListener TListener;
            zzc zzc2 = this;
            synchronized (zzc2) {
                TListener = this.zzcu;
                if (this.zzcv) {
                    String string2 = String.valueOf(this);
                    Log.w((String)"GmsClient", (String)new StringBuilder(47 + String.valueOf(string2).length()).append("Callback proxy ").append(string2).append(" being reused. This is not safe.").toString());
                }
            }
            if (TListener != null) {
                try {
                    this.zza(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.zzn();
                    throw runtimeException;
                }
            } else {
                this.zzn();
            }
            zzc2 = this;
            synchronized (zzc2) {
                this.zzcv = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void unregister() {
            this.removeListener();
            ArrayList arrayList = BaseGmsClient.this.zzch;
            synchronized (arrayList) {
                BaseGmsClient.this.zzch.remove(this);
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeListener() {
            zzc zzc2 = this;
            synchronized (zzc2) {
                this.zzcu = null;
                return;
            }
        }
    }

    final class zzb
    extends com.google.android.gms.internal.common.zze {
        public zzb(Looper looper) {
            super(looper);
        }

        public final void handleMessage(Message message) {
            if (BaseGmsClient.this.zzcr.get() != message.arg1) {
                if (zzb.zzb(message)) {
                    zzb.zza(message);
                }
                return;
            }
            if ((message.what == 1 || message.what == 7 || message.what == 4 && !BaseGmsClient.this.enableLocalFallback() || message.what == 5) && !BaseGmsClient.this.isConnecting()) {
                zzb.zza(message);
                return;
            }
            if (message.what == 4) {
                BaseGmsClient.this.zzco = new ConnectionResult(message.arg2);
                if (BaseGmsClient.this.zzl() && !BaseGmsClient.this.zzcp) {
                    BaseGmsClient.this.zza(3, null);
                    return;
                }
                ConnectionResult connectionResult = BaseGmsClient.this.zzco != null ? BaseGmsClient.this.zzco : new ConnectionResult(8);
                BaseGmsClient.this.zzcf.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 5) {
                ConnectionResult connectionResult = BaseGmsClient.this.zzco != null ? BaseGmsClient.this.zzco : new ConnectionResult(8);
                BaseGmsClient.this.zzcf.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 3) {
                PendingIntent pendingIntent = message.obj instanceof PendingIntent ? (PendingIntent)message.obj : null;
                ConnectionResult connectionResult = new ConnectionResult(message.arg2, pendingIntent);
                BaseGmsClient.this.zzcf.onReportServiceBinding(connectionResult);
                BaseGmsClient.this.onConnectionFailed(connectionResult);
                return;
            }
            if (message.what == 6) {
                BaseGmsClient.this.zza(5, null);
                if (BaseGmsClient.this.zzck != null) {
                    BaseGmsClient.this.zzck.onConnectionSuspended(message.arg2);
                }
                BaseGmsClient.this.onConnectionSuspended(message.arg2);
                BaseGmsClient.this.zza(5, 1, null);
                return;
            }
            if (message.what == 2 && !BaseGmsClient.this.isConnected()) {
                zzb.zza(message);
                return;
            }
            if (zzb.zzb(message)) {
                ((zzc)message.obj).zzo();
                return;
            }
            int n = message.what;
            Log.wtf((String)"GmsClient", (String)new StringBuilder(45).append("Don't know how to handle message: ").append(n).toString(), (Throwable)new Exception());
        }

        private static void zza(Message message) {
            zzc zzc2 = (zzc)message.obj;
            zzc2.zzn();
            zzc2.unregister();
        }

        private static boolean zzb(Message message) {
            return message.what == 2 || message.what == 1 || message.what == 7;
        }
    }

    @KeepForSdk
    public static interface SignOutCallbacks {
        @KeepForSdk
        public void onSignOutComplete();
    }

    @KeepForSdk
    public static interface ConnectionProgressReportCallbacks {
        @KeepForSdk
        public void onReportServiceBinding(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseOnConnectionFailedListener {
        public void onConnectionFailed(@NonNull ConnectionResult var1);
    }

    @KeepForSdk
    public static interface BaseConnectionCallbacks {
        @KeepForSdk
        public void onConnected(@Nullable Bundle var1);

        @KeepForSdk
        public void onConnectionSuspended(int var1);
    }

    @VisibleForTesting
    public final class zze
    implements ServiceConnection {
        private final int zzcx;

        public zze(int n) {
            this.zzcx = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            if (iBinder == null) {
                BaseGmsClient.this.zzb(16);
                return;
            }
            Object object = BaseGmsClient.this.zzcd;
            synchronized (object) {
                IInterface iInterface;
                IBinder iBinder2 = iBinder;
                BaseGmsClient.this.zzce = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.common.internal.IGmsServiceBroker")) != null && iInterface instanceof IGmsServiceBroker ? (IGmsServiceBroker)iInterface : new IGmsServiceBroker.Stub.zza(iBinder2));
            }
            BaseGmsClient.this.zza(0, null, this.zzcx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onServiceDisconnected(ComponentName componentName) {
            Object object = BaseGmsClient.this.zzcd;
            synchronized (object) {
                BaseGmsClient.this.zzce = null;
            }
            BaseGmsClient.this.mHandler.sendMessage(BaseGmsClient.this.mHandler.obtainMessage(6, this.zzcx, 1));
        }
    }
}

