/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.util.zzc;

@KeepForSdk
public final class Preconditions {
    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(@Nullable T t) {
        if (t == null) {
            throw new NullPointerException("null reference");
        }
        return t;
    }

    @KeepForSdk
    public static String checkNotEmpty(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("Given String is empty or null");
        }
        return string2;
    }

    @KeepForSdk
    public static String checkNotEmpty(String string2, Object object) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return string2;
    }

    @KeepForSdk
    @NonNull
    public static <T> T checkNotNull(T t, Object object) {
        if (t == null) {
            throw new NullPointerException(String.valueOf(object));
        }
        return t;
    }

    @KeepForSdk
    public static int checkNotZero(int n, Object object) {
        if (n == 0) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return n;
    }

    @KeepForSdk
    public static int checkNotZero(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Given Integer is zero");
        }
        return n;
    }

    @KeepForSdk
    public static long checkNotZero(long l, Object object) {
        if (l == 0L) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
        return l;
    }

    @KeepForSdk
    public static long checkNotZero(long l) {
        if (l == 0L) {
            throw new IllegalArgumentException("Given Long is zero");
        }
        return l;
    }

    @KeepForSdk
    public static void checkState(boolean bl) {
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    @KeepForSdk
    public static void checkState(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalStateException(String.valueOf(object));
        }
    }

    @KeepForSdk
    public static void checkState(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalStateException(String.format(string2, objectArray));
        }
    }

    @KeepForSdk
    public static void checkArgument(boolean bl, Object object) {
        if (!bl) {
            throw new IllegalArgumentException(String.valueOf(object));
        }
    }

    @KeepForSdk
    public static void checkArgument(boolean bl, String string2, Object ... objectArray) {
        if (!bl) {
            throw new IllegalArgumentException(String.format(string2, objectArray));
        }
    }

    @KeepForSdk
    public static void checkArgument(boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    private Preconditions() {
        throw new AssertionError((Object)"Uninstantiable");
    }

    @KeepForSdk
    public static void checkMainThread(String string2) {
        if (!zzc.isMainThread()) {
            throw new IllegalStateException(string2);
        }
    }

    @KeepForSdk
    public static void checkNotMainThread() {
        Preconditions.checkNotMainThread("Must not be called on the main application thread");
    }

    @KeepForSdk
    public static void checkNotMainThread(String string2) {
        if (zzc.isMainThread()) {
            throw new IllegalStateException(string2);
        }
    }

    @KeepForSdk
    public static void checkHandlerThread(Handler handler) {
        Preconditions.checkHandlerThread(handler, "Must be called on the handler thread");
    }

    @KeepForSdk
    public static void checkHandlerThread(Handler handler, String string2) {
        if (Looper.myLooper() != handler.getLooper()) {
            throw new IllegalStateException(string2);
        }
    }
}

