/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.RemoteInput;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.RequiresApi;
import android.util.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RemoteInput {
    private static final String TAG = "RemoteInput";
    public static final String RESULTS_CLIP_LABEL = "android.remoteinput.results";
    public static final String EXTRA_RESULTS_DATA = "android.remoteinput.resultsData";
    private static final String EXTRA_DATA_TYPE_RESULTS_DATA = "android.remoteinput.dataTypeResultsData";
    private final String mResultKey;
    private final CharSequence mLabel;
    private final CharSequence[] mChoices;
    private final boolean mAllowFreeFormTextInput;
    private final Bundle mExtras;
    private final Set<String> mAllowedDataTypes;

    RemoteInput(String resultKey, CharSequence label, CharSequence[] choices, boolean allowFreeFormTextInput, Bundle extras, Set<String> allowedDataTypes) {
        this.mResultKey = resultKey;
        this.mLabel = label;
        this.mChoices = choices;
        this.mAllowFreeFormTextInput = allowFreeFormTextInput;
        this.mExtras = extras;
        this.mAllowedDataTypes = allowedDataTypes;
    }

    public String getResultKey() {
        return this.mResultKey;
    }

    public CharSequence getLabel() {
        return this.mLabel;
    }

    public CharSequence[] getChoices() {
        return this.mChoices;
    }

    public Set<String> getAllowedDataTypes() {
        return this.mAllowedDataTypes;
    }

    public boolean isDataOnly() {
        return !this.getAllowFreeFormInput() && (this.getChoices() == null || this.getChoices().length == 0) && this.getAllowedDataTypes() != null && !this.getAllowedDataTypes().isEmpty();
    }

    public boolean getAllowFreeFormInput() {
        return this.mAllowFreeFormTextInput;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public static Map<String, Uri> getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
        if (Build.VERSION.SDK_INT >= 26) {
            return android.app.RemoteInput.getDataResultsFromIntent((Intent)intent, (String)remoteInputResultKey);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                return null;
            }
            HashMap<String, Uri> results = new HashMap<String, Uri>();
            Bundle extras = clipDataIntent.getExtras();
            for (String key : extras.keySet()) {
                Bundle bundle;
                String uriStr;
                String mimeType;
                if (!key.startsWith(EXTRA_DATA_TYPE_RESULTS_DATA) || (mimeType = key.substring(EXTRA_DATA_TYPE_RESULTS_DATA.length())).isEmpty() || (uriStr = (bundle = clipDataIntent.getBundleExtra(key)).getString(remoteInputResultKey)) == null || uriStr.isEmpty()) continue;
                results.put(mimeType, Uri.parse((String)uriStr));
            }
            return results.isEmpty() ? null : results;
        }
        Log.w((String)TAG, (String)"RemoteInput is only supported from API Level 16");
        return null;
    }

    public static Bundle getResultsFromIntent(Intent intent) {
        if (Build.VERSION.SDK_INT >= 20) {
            return android.app.RemoteInput.getResultsFromIntent((Intent)intent);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                return null;
            }
            return (Bundle)clipDataIntent.getExtras().getParcelable(EXTRA_RESULTS_DATA);
        }
        Log.w((String)TAG, (String)"RemoteInput is only supported from API Level 16");
        return null;
    }

    public static void addResultsToIntent(RemoteInput[] remoteInputs, Intent intent, Bundle results) {
        if (Build.VERSION.SDK_INT >= 26) {
            android.app.RemoteInput.addResultsToIntent((android.app.RemoteInput[])RemoteInput.fromCompat(remoteInputs), (Intent)intent, (Bundle)results);
        } else if (Build.VERSION.SDK_INT >= 20) {
            Bundle existingTextResults = RemoteInput.getResultsFromIntent(intent);
            if (existingTextResults == null) {
                existingTextResults = results;
            } else {
                existingTextResults.putAll(results);
            }
            for (RemoteInput input : remoteInputs) {
                Map<String, Uri> existingDataResults = RemoteInput.getDataResultsFromIntent(intent, input.getResultKey());
                RemoteInput[] arr = new RemoteInput[]{input};
                android.app.RemoteInput.addResultsToIntent((android.app.RemoteInput[])RemoteInput.fromCompat(arr), (Intent)intent, (Bundle)existingTextResults);
                if (existingDataResults == null) continue;
                RemoteInput.addDataResultToIntent(input, intent, existingDataResults);
            }
        } else if (Build.VERSION.SDK_INT >= 16) {
            Bundle resultsBundle;
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                clipDataIntent = new Intent();
            }
            if ((resultsBundle = clipDataIntent.getBundleExtra(EXTRA_RESULTS_DATA)) == null) {
                resultsBundle = new Bundle();
            }
            for (RemoteInput remoteInput : remoteInputs) {
                Object result = results.get(remoteInput.getResultKey());
                if (!(result instanceof CharSequence)) continue;
                resultsBundle.putCharSequence(remoteInput.getResultKey(), (CharSequence)result);
            }
            clipDataIntent.putExtra(EXTRA_RESULTS_DATA, resultsBundle);
            intent.setClipData(ClipData.newIntent((CharSequence)RESULTS_CLIP_LABEL, (Intent)clipDataIntent));
        } else {
            Log.w((String)TAG, (String)"RemoteInput is only supported from API Level 16");
        }
    }

    public static void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
        if (Build.VERSION.SDK_INT >= 26) {
            android.app.RemoteInput.addDataResultToIntent((android.app.RemoteInput)RemoteInput.fromCompat(remoteInput), (Intent)intent, results);
        } else if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                clipDataIntent = new Intent();
            }
            for (Map.Entry<String, Uri> entry : results.entrySet()) {
                String mimeType = entry.getKey();
                Uri uri = entry.getValue();
                if (mimeType == null) continue;
                Bundle resultsBundle = clipDataIntent.getBundleExtra(RemoteInput.getExtraResultsKeyForData(mimeType));
                if (resultsBundle == null) {
                    resultsBundle = new Bundle();
                }
                resultsBundle.putString(remoteInput.getResultKey(), uri.toString());
                clipDataIntent.putExtra(RemoteInput.getExtraResultsKeyForData(mimeType), resultsBundle);
            }
            intent.setClipData(ClipData.newIntent((CharSequence)RESULTS_CLIP_LABEL, (Intent)clipDataIntent));
        } else {
            Log.w((String)TAG, (String)"RemoteInput is only supported from API Level 16");
        }
    }

    private static String getExtraResultsKeyForData(String mimeType) {
        return EXTRA_DATA_TYPE_RESULTS_DATA + mimeType;
    }

    @RequiresApi(value=20)
    static android.app.RemoteInput[] fromCompat(RemoteInput[] srcArray) {
        if (srcArray == null) {
            return null;
        }
        android.app.RemoteInput[] result = new android.app.RemoteInput[srcArray.length];
        for (int i = 0; i < srcArray.length; ++i) {
            result[i] = RemoteInput.fromCompat(srcArray[i]);
        }
        return result;
    }

    @RequiresApi(value=20)
    static android.app.RemoteInput fromCompat(RemoteInput src) {
        return new RemoteInput.Builder(src.getResultKey()).setLabel(src.getLabel()).setChoices(src.getChoices()).setAllowFreeFormInput(src.getAllowFreeFormInput()).addExtras(src.getExtras()).build();
    }

    @RequiresApi(value=16)
    private static Intent getClipDataIntentFromIntent(Intent intent) {
        ClipData clipData = intent.getClipData();
        if (clipData == null) {
            return null;
        }
        ClipDescription clipDescription = clipData.getDescription();
        if (!clipDescription.hasMimeType("text/vnd.android.intent")) {
            return null;
        }
        if (!clipDescription.getLabel().equals(RESULTS_CLIP_LABEL)) {
            return null;
        }
        return clipData.getItemAt(0).getIntent();
    }

    public static final class Builder {
        private final String mResultKey;
        private CharSequence mLabel;
        private CharSequence[] mChoices;
        private boolean mAllowFreeFormTextInput = true;
        private Bundle mExtras = new Bundle();
        private final Set<String> mAllowedDataTypes = new HashSet<String>();

        public Builder(String resultKey) {
            if (resultKey == null) {
                throw new IllegalArgumentException("Result key can't be null");
            }
            this.mResultKey = resultKey;
        }

        public Builder setLabel(CharSequence label) {
            this.mLabel = label;
            return this;
        }

        public Builder setChoices(CharSequence[] choices) {
            this.mChoices = choices;
            return this;
        }

        public Builder setAllowDataType(String mimeType, boolean doAllow) {
            if (doAllow) {
                this.mAllowedDataTypes.add(mimeType);
            } else {
                this.mAllowedDataTypes.remove(mimeType);
            }
            return this;
        }

        public Builder setAllowFreeFormInput(boolean allowFreeFormTextInput) {
            this.mAllowFreeFormTextInput = allowFreeFormTextInput;
            return this;
        }

        public Builder addExtras(Bundle extras) {
            if (extras != null) {
                this.mExtras.putAll(extras);
            }
            return this;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public RemoteInput build() {
            return new RemoteInput(this.mResultKey, this.mLabel, this.mChoices, this.mAllowFreeFormTextInput, this.mExtras, this.mAllowedDataTypes);
        }
    }
}

