/*
 * Decompiled with CFR 0.152.
 */
package androidx.browser.browseractions;

import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.net.Uri;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.customtabs.R;
import android.support.v4.widget.TextViewCompat;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.browser.browseractions.BrowserActionItem;
import androidx.browser.browseractions.BrowserActionsFallbackMenuAdapter;
import androidx.browser.browseractions.BrowserActionsFallbackMenuDialog;
import androidx.browser.browseractions.BrowserActionsFallbackMenuView;
import java.util.List;

class BrowserActionsFallbackMenuUi
implements AdapterView.OnItemClickListener {
    private static final String TAG = "BrowserActionskMenuUi";
    private final Context mContext;
    private final Uri mUri;
    private final List<BrowserActionItem> mMenuItems;
    private BrowserActionsFallMenuUiListener mMenuUiListener;
    private BrowserActionsFallbackMenuDialog mBrowserActionsDialog;

    BrowserActionsFallbackMenuUi(Context context, Uri uri, List<BrowserActionItem> menuItems) {
        this.mContext = context;
        this.mUri = uri;
        this.mMenuItems = menuItems;
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    void setMenuUiListener(BrowserActionsFallMenuUiListener menuUiListener) {
        this.mMenuUiListener = menuUiListener;
    }

    public void displayMenu() {
        final View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.browser_actions_context_menu_page, null);
        this.mBrowserActionsDialog = new BrowserActionsFallbackMenuDialog(this.mContext, (View)this.initMenuView(view));
        this.mBrowserActionsDialog.setContentView(view);
        if (this.mMenuUiListener != null) {
            this.mBrowserActionsDialog.setOnShowListener(new DialogInterface.OnShowListener(){

                public void onShow(DialogInterface dialogInterface) {
                    BrowserActionsFallbackMenuUi.this.mMenuUiListener.onMenuShown(view);
                }
            });
        }
        this.mBrowserActionsDialog.show();
    }

    private BrowserActionsFallbackMenuView initMenuView(View view) {
        BrowserActionsFallbackMenuView menuView = (BrowserActionsFallbackMenuView)view.findViewById(R.id.browser_actions_menu_view);
        final TextView urlTextView = (TextView)view.findViewById(R.id.browser_actions_header_text);
        urlTextView.setText((CharSequence)this.mUri.toString());
        urlTextView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (TextViewCompat.getMaxLines((TextView)urlTextView) == Integer.MAX_VALUE) {
                    urlTextView.setMaxLines(1);
                    urlTextView.setEllipsize(TextUtils.TruncateAt.END);
                } else {
                    urlTextView.setMaxLines(Integer.MAX_VALUE);
                    urlTextView.setEllipsize(null);
                }
            }
        });
        ListView menuListView = (ListView)view.findViewById(R.id.browser_actions_menu_items);
        BrowserActionsFallbackMenuAdapter adapter = new BrowserActionsFallbackMenuAdapter(this.mMenuItems, this.mContext);
        menuListView.setAdapter((ListAdapter)adapter);
        menuListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        return menuView;
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        PendingIntent action = this.mMenuItems.get(position).getAction();
        try {
            action.send();
            this.mBrowserActionsDialog.dismiss();
        }
        catch (PendingIntent.CanceledException e) {
            Log.e((String)TAG, (String)"Failed to send custom item action", (Throwable)e);
        }
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static interface BrowserActionsFallMenuUiListener {
        public void onMenuShown(View var1);
    }
}

